// ============================================================================
/*
    Copyright 2016 Masaaki Sudo
    http://sudori.info/

    GNU GENERAL PUBLIC LICENSE
    Version 3, 29 June 2007
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
    
    https://www.gnu.org/licenses/gpl.txt
*/
// ============================================================================

// 2016/06/15 音楽関連のオブジェクト定義を独立。現在は未完成で未使用。

/* 
AudioSingle クラスは、html5の標準のAudio要素を使ったゲームBGMを格納し、ループ再生のメソッドを提供する。
同時に2つ以上のオーディオファイルをロードする機能を持たないため、BGM+効果音のミックスなどはできない。
制約として、そもそもAudio要素の再生タイミングは存外に適当。ループも繋ぎが毎回ずれる。
ボタン類の定義はどうする？本クラス内に置くとめんどうかも。あくまで、制御用のスイッチを入れたり切ったりするだけの用途に使うべきか。

最大の問題は拡張子が一通りに決まらない事で、たとえば音声ファイル名が拡張子ごとに違う場合は引数として全部与えなきゃいけないのか？
仕様として hoge.mp3 の hoge だけを引数で与え、名前が違っていてはいけないという制約を付けるとか。
まあ事故った場合に何もファイルを取得できないということはあるので、ここも取得の成否自体をフラグ管理する必要は出てくる。

*/

function AudioSingle(UA, file, loop, startfrom, loopfrom, loopend, endin ) {

    if ( UA.indexOf("iPhone") > 0 || UA.indexOf("iPad") > 0 || UA.indexOf("MSIE") > 0) {
        silent = 1; // iOSのSafariではaudioのロードに失敗するので、窮余の策としてBGM読み込み自体を禁止
    } else {
        this.enable = 0; // 演奏を開始するために必要なフラグだが、自動では立てられないので、後からactivateする必要。
        // ファイルのMIMEタイプ判定して対応形式なら読み込み
        // .canPlayType は probably, maybe, "" （無言）のどれかを返す。
        this.audio = document.createElement('audio');
        this.audio.loop = loop;
        this.audio.startfrom = startfrom; // BGMをイントロから再生するときの開始時点（単位：秒）
        this.audio.loopstart = loopfrom; // BGMをループさせるときの開始時点（単位：秒）
        this.audio.loopend = loopend; // BGMをループさせるときの終点
        this.audio.endin = endin; // もしも途中で強制終了させたい場合。

        if (this.audio.canPlayType('audio/mp4')) {
            var remotefile = String(file+".m4a");
            var fsize = remotefile.fileSize; // リモートにある音声ファイルのファイルサイズを取得
            if (fsize != -1) {
                this.audio.setAttribute('src', remotefile);
            }
        } else if (this.audio.canPlayType('audio/mpeg')) {
            var remotefile = String(file+".mp3");
            var fsize = remotefile.fileSize;
            if (fsize != -1) {
                this.audio.setAttribute('src', remotefile);
            }
        } else if (this.audio.canPlayType('audio/ogg')) {
            var remotefile = String(file+".ogg");
            var fsize = remotefile.fileSize;
            if (fsize != -1) {
                this.audio.setAttribute('src', remotefile);
            }
        } else {
            silent = 1;
        }
        
        if (this.audio.fileSize != 0) {
            // http://www.ibm.com/developerworks/jp/web/library/wa-ioshtml5/
            var bgm_handler = function(event) {
                if (this.currentTime >= this.loopend) {
                    this.currentTime = this.loopstart; // 再生中に再生ヘッドに値を代入すると、頭出し再生になる。
                }
            };
            this.audio.addEventListener('timeupdate', bgm_handler, false); // bgmを自動ループさせる。
        } else {
            silent = 1;
        }
    }
    console.log("silent:"+silent);
}
