// ============================================================================
/*
    Copyright 2016 Masaaki Sudo
    http://sudori.info/

    GNU GENERAL PUBLIC LICENSE
    Version 3, 29 June 2007
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
    
    https://www.gnu.org/licenses/gpl.txt
*/
// ============================================================================

// 戦争では強者が弱者という奴隷を、平和では富者が貧者という奴隷をつくる。

/*
ボタンの実装
もちろんHTMLでもボタンを作れるのだけど、デザインが気に入らねえ場合に。
マウスオーバーに反応させる。ただし、マウスオーバーの判定を自分で作る必要があり、以下に示すがけっこう面倒。

パスの内外判定は isPointInPath が使える。仕様上こいつは、複数のパスがある場合でも最後に開始されたパスからの内外だけを返す。
http://stackoverflow.com/questions/27850703/canvas-ispointinpath-with-multiple-paths
context.isPointInPath only tests the very last path defined (from the last context.beginPath).
つまりはあれか。そのフレームの内部でパスに触れたか否かは、次のパスにならないと反映しないということか。
例えばボタンの図形があって、Object.drawme のメソッド内に isPointInPath を入れても、
情報を取得出来る段階では既に描画が終わってしまっている。
こいつを避けるには、形状を定義するサブルーチンを2回用意しておき、1回目はfillせずに内外判定を行い、2回目でその結果を取り込む必要。
*/


// ============================================================================
// ここから、汎用ボタンを定義
// ============================================================================

// なお、このボタンには今のところ 0 == off, 1 == on の2状態しかない。
function Button(where_x, where_y, w, h, radius, text_array, power, angle, magnify) {
    this.angle = angle;
    this.magnify = magnify;
    this._x = where_x;
    this._y = where_y;
    this.W = w; // w, h が本体の幅と高さ
    this.H = h;
    this.radius = radius; // radiusは箱の角丸の半径。
    this.onMouse = false; // ボタンにマウスが被っていればtrue
    this.text = text_array;
    this.power = power;
}

Button.prototype.setStatus = function(power) {
    this.power = power;
}


// 無回転時の基点を左上とし、任意の場所を中心に回転できる
Button.prototype.offset = function(ctx, angle, magnify, x, y, W, H, cx, cy) {
    ctx.translate(cx, cy);
    ctx.scale(magnify, magnify); // サイズ変更
    ctx.rotate( -angle ); // 中央に移動し、-rotateして、再び左上に戻る。
    ctx.translate(x-cx, y-cy);
};


// 外枠（オプション）
Button.prototype.drawOuter = function (ctx) {
    ctx.beginPath();
    ctx.moveTo(0, 0);
    ctx.lineTo(0, this.H);
    ctx.lineTo(this.W, this.H);
    ctx.lineTo(this.W, 0);
    ctx.lineTo(0, 0);
    ctx.closePath();
    ctx.strokeStyle = "rgba(5, 5, 5, 1)";
    ctx.stroke(); // strokeで輪郭。
};


// ボディ中央マーカー（オプション）
Button.prototype.drawCenter = function (ctx, fill, stroke) {
    ctx.beginPath();
    ctx.arc(this.W/2, this.H/2, this.H/20, 0, Math.PI*2, false);
    ctx.fillStyle = fill;
    ctx.fill();
};


Button.prototype.renderBodyShape = function (ctx) {
    var W = this.W;
    var H = this.H;
    var RD = this.radius

    ctx.beginPath();
    ctx.moveTo(0, RD);
    if (RD < Math.min(W, H)/2) {
        // 角丸四角形か、円弧か。WもしくはHのうちより小さい辺の半分が、角の円の半径より大きい場合、quadraticCurveを使って角丸。
        ctx.lineTo(0, H-RD);
        ctx.quadraticCurveTo(0, H, RD, H); // ひだりした
        ctx.lineTo(W-RD, H);
        ctx.quadraticCurveTo(W, H, W, H-RD); // みぎした
        ctx.lineTo(W, RD);
        ctx.quadraticCurveTo(W, 0, W-RD, 0); // みぎうえ
        ctx.lineTo(RD, 0);
        ctx.quadraticCurveTo(0, 0, 0, RD); // ひだりうえ
    } else {
        // 上記と同じポリゴンだが、もう1回beginPath()する
        ctx.lineTo(0, H-RD);
        ctx.arcTo(0, H, RD, H, RD); // ひだりした
        ctx.lineTo(W-RD, H);
        ctx.arcTo(W, H, W, H-RD, RD); // みぎした
        ctx.lineTo(W, RD);
        ctx.arcTo(W, 0, W-RD, 0, RD); // みぎうえ
        ctx.lineTo(RD, 0);
        ctx.arcTo(0, 0, 0, RD, RD); // ひだりうえ
    }
    ctx.closePath();
};



// ============================================================================
// 他の部品にオーバーレイして使う、進行制御専用のボタン。
// ============================================================================

function ButtonOver(where_x, where_y, w, h, radius, text_array, power, angle, magnify) {
    this.angle = angle;
    this.magnify = magnify;
    this._x = where_x;
    this._y = where_y;
    this.W = w; // w, h が本体の幅と高さ
    this.H = h;
    this.radius = radius; // radiusは箱の角丸の半径。
    this.onMouse = false; // ボタンにマウスが被っていればtrue
    this.text = text_array;
    this.power = power;
    this.waitReset = false; // ゲームが完了して、再初期化の待機状態にあるか。
}


// Buttonオブジェクトの継承
ButtonOver.prototype = new Button();


// 自身を描画。
ButtonOver.prototype.drawme = function (ctx) {
    ctx.save();
    this.offset( ctx, this.angle, this.magnify, this._x, this._y, this.W, this.H, this._x+this.W/2, this._y+this.H/2 );
    this.drawBody(ctx=ctx); // 外形のパス描画。ただしパスの形状定義はButton汎用クラスにある。
    this.drawPict(ctx=ctx); // ピクトグラムのパス描画。renderPictShape メソッドを呼び出す。
    this.drawText(ctx=ctx); // テキストの描画。
    ctx.restore();
};


ButtonOver.prototype.drawBody = function (ctx) {
    // パス定義を繰り返す。1回目はstrokeやfillで本体の描画を行わなず、内外判定だけに使う
    this.renderBodyShape(ctx);
    this.onMouse = ctx.isPointInPath(ctx.mouse_layer_x, ctx.mouse_layer_y); // ここに内外判定。
    this.renderBodyShape(ctx);
    ctx.fillStyle = "hsla("+ctx.darkCol[0]+", "+ctx.darkCol[1]+"%, "+ctx.darkCol[2]+"%, 1)";
    ctx.fill();
    ctx.strokeStyle = "hsla("+ctx.darkCol[0]+", "+ctx.darkCol[1]+"%, "+ctx.darkCol[2]+"%, 1)";
    ctx.lineWidth = 1.8;
    ctx.stroke();
};


ButtonOver.prototype.drawPict = function (ctx) {
    ctx.save();
    if (this.onMouse == true) {
        ctx.shadowOffsetX = -1;
        ctx.shadowOffsetY = -1;
        ctx.shadowColor = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 1.0)";
        ctx.shadowBlur = 5; // ぼかし量
    } else {
        ctx.shadowOffsetX = 1;
        ctx.shadowOffsetY = 1;
        ctx.shadowColor = "hsla("+ctx.baseCol[0]+", "+ctx.baseCol[1]+"%, "+ctx.baseCol[2]+"%, 0.95)";
        ctx.shadowBlur = 8; // ぼかし量
    }
    this.renderPictShape(ctx);
    ctx.clip(); // clipは デバイスピクセル比を変えても正しく反映される。
    ctx.translate(1000, 1000); // いったん図形の外形を外へ飛ばす
    this.renderPictShape(ctx);
    if (this.onMouse == true) {
        ctx.shadowOffsetX = -1000; ctx.shadowOffsetY = -1000; // 影だけ元の位置へ
    } else {
        ctx.shadowOffsetX = -999; ctx.shadowOffsetY = -999;
    }
    ctx.fill(); // こいつがないと影自体描画されない
    ctx.restore(); // restoreしないと後続のtextにまでclipが影響してしまうので注意。
};
// pixel ratio が 1.0 でないとき、shasowを飛ばすと戻ってこないというバグがあったので修正した。
// どうやら shadowOffsetX shadowOffsetY の両メソッドにはdevicePixelRatioが反映されないのですね。想定外だ。
// ところがぎっちょん、viewport width="960px" などとして直接数字を打込んだ場合、この方法は逆に
// ズレを生んでしまう。つまりmeta要素を作り込んだ場合には、何も考えない初期状態で良い。


ButtonOver.prototype.renderPictShape = function (ctx) {
    var W = this.W;
    var H = this.H;
    var RD = this.radius
    
    ctx.beginPath(); // start/pause の三角形などを定義。本来は進行制御専用の図形なので、ここで定義するのはちょっと変。
    if (this.waitReset == false) {
        if (this.power>0) {
            ctx.moveTo(W/2 - H*0.09, H/2 - H*0.28);
            ctx.lineTo(W/2 - H*0.09, H/2 + H*0.28);
            ctx.lineTo(W/2 - H*0.31, H/2 + H*0.28);
            ctx.lineTo(W/2 - H*0.31, H/2 - H*0.28);
            ctx.moveTo(W/2 + H*0.09, H/2 - H*0.28);
            ctx.lineTo(W/2 + H*0.09, H/2 + H*0.28);
            ctx.lineTo(W/2 + H*0.31, H/2 + H*0.28);
            ctx.lineTo(W/2 + H*0.31, H/2 - H*0.28);
        } else {
            ctx.moveTo(W/2 - H*0.3+RD/10, H/2 - H*0.35);
            ctx.lineTo(W/2 - H*0.3+RD/10, H/2 + H*0.35);
            ctx.lineTo(W/2 + H*0.4, H/2 );
            ctx.lineTo(W/2 - H*0.3+RD/10, H/2 - H*0.35);
        }
    } else {
        ctx.arc( x=W/2, y=H/2, radius=H*0.35, startAngle=-Math.PI/2, endAngle=Math.PI*1.35, anticlockwise=false);
        ctx.lineTo(W/2+W*0.2*Math.cos(Math.PI*1.35), H/2+H*0.2*Math.sin(Math.PI*1.35) );
        ctx.lineTo(W*(0.5+0.32*Math.cos(Math.PI*1.45)), H*(0.5+0.32*Math.sin(Math.PI*1.45)) );
        ctx.lineTo(W/2+W*0.4*Math.cos(Math.PI*1.35), H/2+H*0.4*Math.sin(Math.PI*1.35) );
        ctx.arc( x=W/2, y=H/2, radius=H*0.25, startAngle=Math.PI*1.35, endAngle=-Math.PI/2, anticlockwise=true);
    }
    ctx.closePath();
};


// 文字の描画処理。
ButtonOver.prototype.drawText = function (ctx) {

    ctx.save();
    if (this.onMouse == true) {
        ctx.fillStyle = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 1.0)";
        ctx.shadowOffsetX = -1;
        ctx.shadowOffsetY = -1;
        ctx.shadowColor = "rgba(0, 0, 5, 0.60)";
        ctx.shadowBlur = 1; // ぼかし量
    } else {
        ctx.fillStyle = "hsla("+ctx.baseCol[0]+", "+ctx.baseCol[1]+"%, "+ctx.baseCol[2]+"%, 0.30)";
        ctx.shadowOffsetX = -1;
        ctx.shadowOffsetY = -1;
        ctx.shadowColor = "rgba(0, 0, 5, 0.51)";
        ctx.shadowBlur = 1; // ぼかし量
    }
    ctx.font= '16pt Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    if (this.waitReset == false) {
        ctx.fillText( this.text[power], this.W/2, this.H*0.1, this.W); // テキストは形状指定と同時に描画される
    } else {
        ctx.fillText( "PRESS RELOAD", this.W/2, this.H*0.1, this.W); // テキストは形状指定と同時に描画される
    }
    ctx.restore();
}



// ============================================================================
// 位置固定、ライト表示なし、かつ形状が丸いボタン。サークルの中心として where_x/y を定義する仕様。
// ============================================================================


function ButtonSA(where_x, where_y, w, h, radius, text_array, power, angle, magnify) {
    this.angle = angle;
    this.magnify = magnify;
    this._x = where_x;
    this._y = where_y;
    this.W = w; // w, h が本体の幅と高さ
    this.H = h;
    this.radius = radius; // radiusは箱の角丸の半径。
    this.onMouse = false; // ボタンにマウスが被っていればtrue
    this.text = text_array;
    this.power = power;
}


// Buttonオブジェクトの継承
ButtonSA.prototype = new Button();


// 自身を描画。
ButtonSA.prototype.drawme = function (ctx) {
    ctx.save();
    this.offset( ctx, this.angle, this.magnify, this._x, this._y, this.W, this.H, this._x+this.W/2, this._y+this.H/2 );
    ctx.translate(-W/2, -H/2);
    this.drawBody(ctx=ctx);
    this.drawText(ctx=ctx);
    ctx.translate(W/2, H/2);
    ctx.restore();
};


ButtonSA.prototype.drawBody = function (ctx) {

    ctx.save(); // 事前セーブ
    var FILL0 = "hsla("+ctx.baseCol[0]+", "+ctx.baseCol[1]+"%, "+ctx.baseCol[2]+"%, 1)";
    var FILL1 = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 0.025)";

    // パス定義を繰り返す。1回目はstrokeやfillで本体の描画を行わなず、内外判定だけに使う
    this.renderBodyShape(ctx);
    this.onMouse = ctx.isPointInPath(ctx.mouse_layer_x, ctx.mouse_layer_y);    // ここに内外判定。
    this.renderBodyShape(ctx);
    if (this.onMouse == true) {
        ctx.shadowOffsetX = 0;
        ctx.shadowOffsetY = 0;
        ctx.shadowColor = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 0.5)";
        ctx.shadowBlur = 2; // ぼかし量
        ctx.fillStyle = FILL1;
        ctx.strokeStyle = "hsla("+ctx.darkCol[0]+", "+ctx.darkCol[1]+"%, "+ctx.darkCol[2]+"%, 1.0)";
    } else {
        ctx.shadowOffsetX = 1;
        ctx.shadowOffsetY = 1;
        ctx.shadowColor = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 0.5)";
        ctx.shadowBlur = 2; // ぼかし量
        ctx.fillStyle = FILL0;
        ctx.strokeStyle = "hsla("+ctx.darkCol[0]+", "+ctx.darkCol[1]+"%, "+ctx.darkCol[2]+"%, 0.7)";
    }
    ctx.fill();
    ctx.lineWidth = 4;
    ctx.stroke();

    ctx.restore(); // restoreしないと後続のtextにまでshadowが影響してしまうので注意。
};



// 文字の描画処理。
ButtonSA.prototype.drawText = function (ctx) {

    ctx.save();
    var FILL0 = "hsla("+ctx.baseCol[0]+", "+ctx.baseCol[1]+"%, "+ctx.liteCol[2]+"%, 1)"; // 塗りつぶし。
    var FILL1 = "hsla("+ctx.semiCol[0]+", "+ctx.semiCol[1]+"%, "+ctx.darkCol[2]+"%, 0.995)"; // 塗りつぶし。

    if (this.onMouse == true) {
        ctx.shadowOffsetX = 0.5;
        ctx.shadowOffsetY = 0.5;
        ctx.shadowColor = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 0.5)";
        ctx.shadowBlur = 2; // ぼかし量
        ctx.fillStyle = FILL1;
    } else {
        ctx.shadowOffsetX = -1;
        ctx.shadowOffsetY = -1;
        ctx.shadowColor = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.darkCol[2]+"%, 0.5)";
        ctx.shadowBlur = 2; // ぼかし量
        ctx.fillStyle = FILL0;
    }
    ctx.font= '24pt Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText( this.text[power], this.W/2, this.H/2, this.W);

    ctx.restore();
}


// ============================================================================
// BGMを有効にするためのボタン
// ============================================================================


function ButtonBGM(where_x, where_y, w, h, radius, text_array, power, angle, magnify) {
    this.angle = angle;
    this.magnify = magnify;
    this._x = where_x;
    this._y = where_y;
    this.W = w; // w, h が本体の幅と高さ
    this.H = h;
    this.radius = radius; // radiusは箱の角丸の半径。
    this.onMouse = false; // ボタンにマウスが被っていればtrue
    this.text = text_array;
    this.power = power;
}


// Buttonオブジェクトの継承
ButtonBGM.prototype = new Button();


// 自身を描画。
ButtonBGM.prototype.drawme = function (ctx) {
    ctx.save();
    this.offset( ctx=ctx, angle=this.angle, magnify=this.magnify, x=this._x, y=this._y, 
                 W=this.W, H=this.H, cx=this._x+this.W/2, cy=this._y+this.H/2 );
    this.drawBody(ctx=ctx);
    this.drawText(ctx=ctx);
    ctx.restore();
};


ButtonBGM.prototype.drawBody = function (ctx) {

    ctx.save();
    // パス定義を繰り返す。1回目はstrokeやfillで本体の描画を行わなず、内外判定だけに使う。
    // 今回はボタンが複雑な形をしているため、形状定義ではなく単なる丸を描いて内外判定に使う。
    ctx.arc(this.W/2, this.H/2, this.radius/2, 0, Math.PI*2, false);
    this.onMouse = ctx.isPointInPath(ctx.mouse_layer_x, ctx.mouse_layer_y); // ここに内外判定。
    this.renderBodyShape(ctx);
    var FILL0 = "hsla("+ctx.baseCol[0]+", "+ctx.baseCol[1]+"%, "+ctx.baseCol[2]+"%, 1)"; // 塗りつぶし。
    var FILL1 = "hsla("+ctx.semiCol[0]+", "+ctx.semiCol[1]+"%, "+ctx.semiCol[2]+"%, 1)"; // 塗りつぶし。

    if (this.onMouse == true) {
        ctx.shadowOffsetX = -1;
        ctx.shadowOffsetY = -1;
        ctx.shadowColor = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.darkCol[2]+"%, 0.95)";
        ctx.shadowBlur = 3; // ぼかし量
        ctx.fillStyle = FILL1;
    } else {
        ctx.shadowOffsetX = 1;
        ctx.shadowOffsetY = 1;
        ctx.shadowColor = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 0.5)";
        ctx.shadowBlur = 3; // ぼかし量
        ctx.fillStyle = FILL0;
    }
    ctx.fill();

    ctx.strokeStyle = "hsla("+ctx.liteCol[0]+", "+ctx.liteCol[1]+"%, "+ctx.liteCol[2]+"%, 1.0)";
    ctx.lineWidth = 2;
    ctx.stroke();
    ctx.restore(); // restoreしないと後続のtextにまでshadowが影響してしまうので注意。
};


ButtonBGM.prototype.renderBodyShape = function (ctx) {
    var W = this.W;
    var H = this.H;
    var DL = this.H/6;
    var DX = this.W/4;

    ctx.beginPath();
    ctx.moveTo(0, H/2-DL);
    ctx.lineTo(0, H/2-DL);
    ctx.lineTo(0, H/2+DL);
    ctx.lineTo(DX, H/2+DL);
    ctx.lineTo(W/2, H);
    ctx.lineTo(W/2, 0);
    ctx.lineTo(DX, H/2-DL);
    ctx.closePath();
    if (this.power <= 0) {
        ctx.moveTo(0, H);
        ctx.lineTo(W, 0);
    } else {
        ctx.moveTo(0 + this.W*0.65*Math.cos(-Math.PI*0.15), this.H/2 + this.W*0.65*Math.sin(-Math.PI*0.15));
        ctx.arc(0, this.H/2, this.W*0.65, -Math.PI*0.15, Math.PI*0.15, false);
        if (this.power > 0.33) {
            ctx.moveTo(0 + this.W*0.825*Math.cos(-Math.PI*0.15), this.H/2 + this.W*0.825*Math.sin(-Math.PI*0.15));
            ctx.arc(0, this.H/2, this.W*0.825, -Math.PI*0.15, Math.PI*0.15, false);
        }
        if (this.power > 0.67) {
            ctx.moveTo(0 + this.W*1.0*Math.cos(-Math.PI*0.15), this.H/2 + this.W*1.0*Math.sin(-Math.PI*0.15));
            ctx.arc(0, this.H/2, this.W*1.0, -Math.PI*0.15, Math.PI*0.15, false);
        }
    }
};



// 文字の描画処理。
ButtonBGM.prototype.drawText = function (ctx) {

    ctx.save();

    if (this.onMouse == true) {
        ctx.shadowOffsetX = -1;
        ctx.shadowOffsetY = -1;
        ctx.shadowColor = "rgba(50, 150, 255, 1.0)";
        ctx.shadowBlur = 6; // ぼかし量
        ctx.fillStyle = "rgba(255, 255, 255, 1.0)";
    } else {
        ctx.shadowOffsetX = -1;
        ctx.shadowOffsetY = -1;
        ctx.shadowColor = "rgba(250, 250, 255, 0.51)";
        ctx.shadowBlur = 2; // ぼかし量
        ctx.fillStyle = "rgba(255, 255, 255, 1)";
    }

    ctx.font= '24pt Arial';
    ctx.textAlign = 'center';
    ctx.textBaseline = 'middle';
    ctx.fillText( this.text[power], this.W/2, this.H/2, this.W);

    ctx.restore();
}
