// ============================================================================
/*
    Copyright 2016 Masaaki Sudo
    http://sudori.info/

    GNU GENERAL PUBLIC LICENSE
    Version 3, 29 June 2007
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
    
    https://www.gnu.org/licenses/gpl.txt
*/
// ============================================================================

// ============================================================================
/*
2016/01/09
キャラクターのクラスについて
カブリダニだろうがハダニだろうが、キャラクターデザイン部分の詳細を除けば必要な処理は似通っている
つまり、キャラクターのクラスを継承する形でカブリダニとかハダニとかを定義するべきである。

一般に、このような用途ではサブクラスを使う。
javascriptでどうやって実現するか？
たとえば以下のように。
http://blog.livedoor.jp/kamikaze_cyclone/archives/33832818.html
// var Humanとしてクラス定義されているとき、Humanオブジェクトを継承するオブジェクト
var Children = function(club) {
    this.club = club
}
// Humanオブジェクトの継承
Children.prototype = new Human();

なので上位クラスをCharacterとして、サブクラスKaburiと同じくサブクラスHadaniを作るのがベターか。
この場合、Characterには初期化、フレーム毎の座標オフセットなど、共通するメソッドを定義。
drawmeとしていた部分は、Characterのクラスメソッドにしていいが、キャラクター毎の形状デザインを関数に分離する必要。

*/
// ============================================================================


// Characterクラスを自作する
function Character(fromX, fromY, toX, toY, where_x, where_y) {
    this.fromX=fromX; 
    this.fromY=fromY; 
    this.toX=toX; 
    this.toY=toY; 
    this.init_angle = -Math.PI/2; // 単位をラジアンに統一。ゼロは上ではなく右になる事に注意。
    this.init_magnify = 2.0;
    this.init_speed = 10;
    this.size = 0;
    this.rotate = false;
    this.angle = this.init_angle;
    this.magnify = this.init_magnify;
    this._x = where_x;
    this._y = where_y;
    this.speed = this.init_speed;
    this.moment_x = 0; // そのフレームで動くかどうか_x: なお左に動く場合はマイナス1になる。
    this.moment_y = 0; // そのフレームで動くかどうか_y: 
    this.move_x = 0; // 毎フレームの移動量_x
    this.move_y = 0; // 毎フレームの移動量_y
}

// 自作クラスに対し、クラスメソッドを定義するために .prototype を使う 
// http://qiita.com/takeharu/items/809114f943208aaf55b3
// 実はprototypeを使わなくてもメソッドを定義出来るが、その場合はインスタンス毎にメモリを食う


// グローバル座標上のキャラクター位置を指定位置に移動し、さらに描画領域の中心にオフセット。
// rotateだけだと「左上の原点を中心に、反時計回りで」という直感に反した動きなので注意。
Character.prototype.offset = function(ctx, rad, magnify, where_x, where_y, W_CTX, H_CTX) {
    ctx.translate(where_x - W_CTX*magnify/2, where_y - H_CTX*magnify/2); 
    ctx.scale(magnify, magnify); // サイズ変更
    ctx.translate(W_CTX/2, H_CTX/2);
    ctx.rotate( rad + Math.PI/2 ); // ラジアンである事に注意。
    ctx.translate(-W_CTX/2, -H_CTX/2);
}



Character.prototype.offset_norot = function(ctx, rad, magnify, where_x, where_y, W_CTX, H_CTX) {
    ctx.translate(where_x - W_CTX*magnify/2, where_y - H_CTX*magnify/2); 
    ctx.scale(magnify, magnify); // サイズ変更
}

