// ============================================================================
/*
    Copyright 2016 Masaaki Sudo
    http://sudori.info/

    GNU GENERAL PUBLIC LICENSE
    Version 3, 29 June 2007
    
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
    
    https://www.gnu.org/licenses/gpl.txt
*/
// ============================================================================


// - global グローバル変数宣言 -------------------------------------------------------------------
var VERSION = 1.0;
var UA = navigator.userAgent; // ユーザーエージェント取得。
console.log(UA);
var game = true; // game フラグはゲームループと連動しているので、一旦おろすと再開出来ない事に注意。基本的にtrueのままで。
var run = 0; // ゲーム開始→一時停止→再開のフラグはこちらを使う。
var enable_bgm = 0; // BGMを再生するか。規定値はゼロでBGMを再生しない。
var silent = 0; // 各種オプションにかかわらず、BGM再生を禁止するか。後述するようにiOSで原因未解明のエラーが出るので、抑止策。

var show_config = 1; // 2016/05/24追加。ゲームのコンフィグ画面を表示するか
var show_debug = 1; // 2016/05/24追加。ゲームのデバッグモードに入るか
var w_hidden = 50; // 上記でコンフィグやデバッグを隠した時に、引き出し用にチラ見せする幅
var show_link = 1; // 2016/07/04追加。栄養間リンクの設定画面を描画するか。ゲーム中はオーバーレイなのでマウス位置依存
var scroll_lock = 1; // ゲーム画面でスクロールをロックするか。最初はロックする

var stage = 0; // ゲームのステージ。
// stage == 0 初期画面
// stage == 1x ゲーム本編ステージ1面
// stage == 101 ゲームオーバー後の成績表示
// stage == 201 ゲームクリア後の結果表示および送信画面（まだ通信機能を実装していないが）
// stage == 301 統計解析（未実装）
var FPS = 1000 / 20; // 正しくは分母が frames per second に等しい。商だと、何ミリ秒後に次フレームを描画するかという意味に。
var MAXTIME = 2000; // ゲームの最大プレイ時間を何フレームにするか。可変長の配列を使いたくないときは、こいつをつかって初期化。

var THEME_COL_H = Math.random()*360; // ゲーム画面のメインの色相を決める。何が出るかはロードごとのお楽しみ
var THEME_COL_S = 50; // ゲーム画面の彩度の基準（単位%）。
var BASE_COL = Array(THEME_COL_H, THEME_COL_S, 45); // hslなので注意。
var SEMI_COL = Array(THEME_COL_H, THEME_COL_S, 30); // hslなので注意。
var DARK_COL = Array(THEME_COL_H, THEME_COL_S, 20); // hslなので注意。
var LITE_COL = Array(THEME_COL_H, THEME_COL_S, 98); // hslなので注意。
var HADANI_COL_ARRAY = ["hsla(50, 100%, 95%, 1)",
                        "hsla(70, 100%, 50%, 1)",
                        "hsla(100, 100%, 80%, 1)",
                        "hsla(160, 100%, 55%, 1)",
                        "hsla(325, 100%, 55%, 1)"];
var HADANI_COL_ARRAY2 =["hsla(210, 100%, 100%, 1)",
                        "hsla(70, 100%, 0%, 1)",
                        "hsla(120, 100%, 80%, 1)",
                        "hsla(150, 100%, 55%, 1)",
                        "hsla(330, 100%, 55%, 1)"];
var HADANI_LEG_COLOR = "rgba(255, 255, 255, 1)"; // only for teleiochrysalis
var HADANI_EYE_COLOR = "rgba(10, 10, 50, 1)";

// カブリダニ関係の定数は他から触る必要がないので、 Kaburi クラスのプロパティとして定義している。
// ハダニの方はplotでも使う数字があるので、グローバル変数に残している。
// ハダニ関係のグローバル変数（定数）
var HADANI_SIZE = 0.850; // ハダニ個体の表示倍率。まず初期値を定数で与えておく。
var HADANI_FOUNDER = 5; // 何個体のハダニインスタンスから開始するか。ただしタイトル画面でユーザーが増減できる。
var HADANI_FOUNDER_MAX = 10; // ハダニ初期個体数の許可される最大
var HADANI_MAX = 1000; // のべ何個のハダニインスタンスを生成していいか。ハードのメモリ次第だが、それほど大きくなくてもよい
var HADANI_MALE_RATIO = 0.5; // 個体群レベルでのハダニの性比（オスの割合）。

// 以下の各変数は、各個体のsetStatusにおいて参照される定数。順に [卵、幼虫、静止期、雌成虫、オス成虫]
var HADANI_SPEED_ARRAY = [0, 6, 0, 9, 13]; // ハダニの各ステージの移動速度（毎フレームにおけるランダムウォークの移動距離）
var HADANI_HEAD_ARRAY = [0, 0.07, 0, 0.1, 0.025]; // ハダニの各ステージの首振り角度（最大）
// 配列が長さ7のときは [0=未割当、1=卵、2=幼虫、3=静止期、4=雌成虫、5=オス成虫、6=死亡]
var HADANI_LIFETIME_CUMUL_ARRAY = [0, 100, 200, 300, 550, 750]; // i番目の発育ステージは ARRAY[i-1] < age <= ARRAY[i]
var HADANI_LEN_MALE = HADANI_LIFETIME_CUMUL_ARRAY[5] - HADANI_LIFETIME_CUMUL_ARRAY[4];
var HADANI_LEN_FEMALE = HADANI_LIFETIME_CUMUL_ARRAY[4] - HADANI_LIFETIME_CUMUL_ARRAY[3];

var HADANI_FORAGE_ARRAY = [0, 0.005, 0, 0.02, 0.005]; //ハダニの単位時間辺り捕食量
var HADANI_FECUNDITY_MAX = 10; // ハダニ雌1個体当たりの最大産卵数
var HADANI_LAYEGG_YORK = 0.6; // 次の産卵に必要な栄養の蓄積量。雌成虫のみ必要
var HADANI_CEASE_PROB_ARRAY = [0.01, 0.02, 0.03, 0.01, 0.02]; // 単位時間（フレーム）ごとの死亡確率だが自然死は未実装

var CRITICAL_DIST_ARRAY = [25, 25, 25, 25, 25]; // ハダニとカブリダニの衝突判定に用いられる臨界距離の配列。
var AVOID_DIST_ARRAY = [0, 60, 0, 90, 70]; // カブリダニとの距離がこれ未満だとハダニが逃げようとがんばる

// 食物連鎖関連のグローバル変数。configから弄る。
var chain_plant_hadani = 1; // ハダニによる植物の消費のリンク
var chain_hadani_kaburi = 1; // カブリによるハダニ捕食のリンク。なおハダニによるカブリ回避も連動
var kaburi_power_supply = 1; // カブリダニを電源につなぐ。

// 画面配置関連のグローバル変数
var BASE_W = 800;
var BASE_H = 800;
var LEAF_FROM_X = 20;
var LEAF_FROM_Y = 20;
var LEAF_W = 480;
var LEAF_H = 480;
var LEAF_MARGIN = 10;

var PLOT_W = 200;
var PLOT_H = 200;
var PLOT_MARGIN = 20;
var PLOT_FROM_X = LEAF_FROM_X+LEAF_W+LEAF_MARGIN+40;
var PLOT_FROM_Y = LEAF_FROM_Y+PLOT_H-LEAF_MARGIN+PLOT_MARGIN;
var YTICKM =HADANI_MAX/4; // グラフのY軸の上限。多すぎても少なすぎても見た目がしょぼくなる。

// 背景画像のロード // 相対パスの場合、jsファイルではなくインクルード先のhtmlからのパスなので注意。
var texture_base = new Image();
var texture_leaf = new Image();
var texture_seg = new Image();
texture_base.src = 'image/base256tr.png';
texture_leaf.src = 'image/halftone252b.png';
texture_seg.src = 'image/halftone254g.png';

var PIX_RATIO = window.devicePixelRatio; // 現在のデバイスピクセル比（html文書の1pxをデバイスの何pxで表示するか）

/*
（注意）伝統的なhtmlやcssを扱うときの、オブジェクトのいわゆる論理上のピクセルは、正しくはCSSピクセル（css pixel）という。
一方、上記のオブジェクトがデバイスの物理画素に占める表示幅を議論しているときの単位は、デバイスピクセル（device pixel）と呼ばれる。
以前は devicePixelRatio が 1.0 でないディスプレイが一般に知られていなかったため
device pixel == css pixel  でよかったが、Retinaディスプレイが登場したせいで
device pixel = css pixel * devicePixelRatio
として、明示的に捉える必要が出てきた。
devicePixelRatioの値は、例えばiPhone4では2.0だが、最近のスマホには3.0なんてのもあるらしい。

2016/06/25 マウス座標の調整はさらに厄介。
<meta name="viewport" content="width=960px">
などとして直接widthを指定している時のみは、devicePixelRatioに応じて調整を行う必要すらないようだ。面倒な仕様だなあ。
*/

// responsive designに対応させるため、現在のwindowの幅と高さをjavascriptに取得させる。以下のようなプロパティがある。
// screenはブラウザではなくディスプレイそのものの描画領域
console.log("window.screen:"+window.screen);
console.log("screen:"+screen.width+","+screen.height);
console.log("window:"+window.innerWidth+","+window.innerHeight); // windowはブラウザの描画領域。ページデザインに必要
console.log("orientation:"+window.orientation); // 90で3時、180で6時、-90で9時。PCではundefined。deprecatedなので注意。
console.log("devicePixelRatio:"+window.devicePixelRatio);

/*
他にも以下のような window.screen オブジェクトがある。
availWidth	Number	描画に利用可能な幅を取得する。（デスクトップに相当）
availHeight	Number	描画に利用可能な高さを取得する。（デスクトップに相当）
width	Number	出力デバイスの幅を取得する。（物理的なスペック）
height	Number	出力デバイスの高さを取得する。（物理的なスペック）
colorDepth	Number	色深度のビット数を取得する。
pixelDepth	Number	色深度のビット数を取得する。

で、PCだと window.innerWidth, window.innerHeight が、大体1000x600くらいの値になる。
iPhone5だと、cssピクセルが320x568で、物理ピクセルが640x1136である（portrait、つまり縦長の時）。
簡単に言うと、スマホのlandscapeで保持した時の画面とPCのブラウザ画面をほぼ同列に扱っていい。
スマホのportraitでゲームをプレイさせるのは、ボタンが豆粒サイズなのでハードルが高すぎる。
*/


// 歌舞音曲の類を流す -------------------------------------------------------------------

// 最低限aac形式の音声データを用意する必要。さもないとiOSで対応可能なフォーマットがなく、全く音が出ない。
// それでもなぜかvar bgmの初期化に失敗して、存在しない音声のメタデータを取得しようとする等の過程により、致命的エラーが誘発される。
// iOS6以上ではWeb Audio APIが使える。或いはそちらで書き直したほうがいいかもしれんが、ちょっとオーバースペックすぎる。

/*
下のコードはオーディオオブジェクトの定義だけなので、制御ボタンは別の場所で定義して描画させる。
基本的に、audio制御のボタンはゲームのステージ進行の影響を受けない場所に置くべき。
本来であればAudio関係のモジュールもまとめてクラス化し、別のファイルに置くと見通しが良くなる。
ただ、再生可能なファイルタイプの判定について幾分、面倒な点があるので保留。引数の数が「候補」の数だけ増えてしまうという面倒なことに。
最初にmain側でsetAttributeしてから放り込む手はあるが、そこまでやるとmain側のコード行数がほとんど減らず、メリットがない。
*/

// HTMLから直接リンクされた音声ファイルから、BGM用のオーディオオブジェクトを作るには以下。
// var bgm = document.getElementById('audio'); // HTML側に再生コントローラーを儲けたい場合は、イベントリスナーで取得する。

// 今回は完全にバックグラウンド動作させるので、js内でAudio要素を作る。 最初にaudio.canPlayType('mime type') で対応形式を判定。

if ( UA.indexOf("iPhone") > 0 || UA.indexOf("iPad") > 0) {
    silent = 1; // なぜかiOSのSafariではaudioのロードに失敗するので、窮余の策としてBGM読み込み自体を禁止
}
if (silent <= 0) {
    var bgm = document.createElement('audio');
    if (bgm.canPlayType('audio/mp4')) { // probably, maybe, "" （無言）のどれか。
    bgm.setAttribute('src','audio/sheep02.m4a'); // iOSのSafariでは失敗する
    } else if (bgm.canPlayType('audio/mpeg')) {
        bgm.setAttribute('src','audio/sheep02.mp3');
    } else if (bgm.canPlayType('audio/ogg')) {
        bgm.setAttribute('src','audio/sheep02.ogg'); // どちらもプレイできるとき、後から指定した形式で上書き。
    } else {
        silent = 1;
    }
    bgm.loop = 'false'; // まだ作りこんでおらず、現在はBGMが強制ループする。
    bgm.startfrom = 0.01; // BGMをイントロから再生するときの開始時点（単位：秒）// 必ず曲が始まる前の無音箇所から始めよ
    bgm.loopstart = 12.32; // BGMをループさせるときの開始時点（単位：秒）
    bgm.loopend = 223.25; // BGMをループさせるときの終点。ファイル本体より長ければ、曲末に達した時点でファイル冒頭に巻き戻る。

    // http://www.ibm.com/developerworks/jp/web/library/wa-ioshtml5/
    var bgm_handler = function(event) {
        if (this.currentTime >= this.loopend) {
            this.currentTime = this.loopstart; // 再生中に再生ヘッドに値を代入すると、頭出し再生になる。
        }
    };
    bgm.addEventListener('timeupdate', bgm_handler, false); // bgmを自動ループさせる。
    // 注意：この方法で曲がりなりにも、曲のイントロ・アウトロを除く中間地点間をループできるが、時間はあまり厳密でない。
    // テンポが遅く、かつ音がある程度スカスカな曲でないと、明らかにぶつ切り状態になる。
    // 基本的にaudio要素はその程度の出来であり、Web Audio APIを使った高度な制御が必要。まあ音ゲーじゃないので、適当でもいいだろう。

    console.log("Audio set");
}


// - onload ロード時に読み込まれる -------------------------------------------------------------------

// ただしモバイル系のブラウザは通信量節約のため、HTML5の標準的な手続きを無視してonloadでの処理の一部を実行しない。
// たとえばaudio要素のpreloadはかからない。ユーザーの何らかのtouchイベントにひもづける必要。

/*
現在は init() 関数の定義の中に無名関数の定義がそのまま埋め込まれていて、その中にゲームのループ処理が入っている。
無名関数そのものを別の場所で定義する事は容易ではないので、今後ステージそのものを複数設けるには、以下の方針で作る。
「無名関数の前」：純粋に、タイトルフレーム以前に実施すべきゲームの初期化処理だけ入れる
「無形関数の中」：var stage で、ゲームのステージを擬似的に管理する。
初期画面がstage == 0、ゲーム本編は1ステージ目からと仮定し、各フレームの処理はサブルーチンに定義。

2016/06/08 OTB拾い
ゲームが終わって、単純にページを更新するならば、適当なボタンに以下のイベントを紐付けてやればいい。
location.reload(true); // WEBサーバのデータからリロード、
location.reload(false); // キャッシュからリロード。

なお、現在のバージョンにおいてページをリロードした場合は、既存の設定もゲーム内状態もリセットされる。
データを保持するには cookie (max. 4 kB) や
Web Strage (max. 5 MB: 今回はタブ単位でデータを保持、シャットダウンしたら破棄するのでsessionStorageがいい) を使う。
たとえば
var storage = sessionStrage;
storage.setItem('game_current_frame', frame_raw); // 第一引数で指定した名前のキーに値をセット
storage.getItem('game_current_frame'); //
storage.clear(); // データクリア
for (var i; i <= storage.length; i=(i+1)|0) {
    console.log(storage.key(i)); // ストレージにどんなキーが存在するか
}

じゃあ、リロードせずに、単純に個体群をリセットしたい場合はどうする？
たとえば葉っぱ、ハダニ、カブリダニ、グラフをそれぞれ、初期設定に戻すresetメソッドを別途、準備する。

ゲームプロセスの記録と再生については、セキュリティリスクの調査が済んでいないので後のバージョンで対応したい。
*/


// - onload ロード時に読み込まれる -------------------------------------------------------------------
window.onload = function() {
    init(); // 下で定義する init() 関数。内部にゲームループも含まれる。
}

// init() 関数の定義 -------------------------------------------------------------------
function init() {
    var dynamic_title = "KABURI CANVAS " + "version " + VERSION.toFixed(2); // <html> page titleの動的生成。小数点以下2桁強制
    document.getElementById('dyntitle').innerHTML = dynamic_title;

    if (silent <= 0) {
        bgm.load(); // 基本的にはBGMのデフォルトを「無効」、BGM有効化ボタンを押したら初めて load (=download)
        // そもそもモバイル環境ではユーザーがタッチイベントを起こさない限り load されないためである。
        bgm.currentTime = (bgm.startfrom); // ロード直後に開始地点へ移動。
    }
    var d = new Date();    // 現在時刻をミリ秒単位で変数に代入
    var oldd = d;
    var d2 = d; // d2はループの各回のラストでの時刻。実際の時間は後で入れるが、先に初期化だけしておく。
    var oldd2 = d;
    var pss = 0;
    var frame_raw = 0; // ゲーム開始時からの経過フレーム数。もちろんタイトル画面までは0

    // デバイスからの入力受付 -------------------------------------------------------------------

    // 今後キーボード関連のイベントがあれば、いちいちループ毎に状態更新しなくてもinput_keysが最新のキーボード押下状態を保持。
    var input_keys = new InputKeys();

    // 以下コメントアウトは、javascriptでクリックイベントを取得する古典的手続き。だがスマホのtapに対応できないので破棄。
/*    document.onclick = function (e) {
        if(!e) e = window.event; // レガシー
        input_click = true;
    };
*/
    // 代わって、以下のイベントリスナーを新たに開発した。これはタッチデバイスでのタップをクリック相当のイベントに読み替えてくれる。
    // なお素の touchstart イベントは、数百ミリ秒後に onclick イベントを自動発行してしまうという嫌な癖がある。
    // つまり、2回ボタンを押したことになってしまう。
    // これを避けるため、document.onclickでクリックを取得するのではなく、エレメントにaddEventListenerで'click'時の挙動を
    // 付与し、タップが無いことを確認できた場合のみクリック相当のイベントを発火させるという設計が有効。
    // 下記の改良版イベントリスナー関数でもなお、ユーザーがtapして数十ミリ秒以内にmouse clickするという操作を行った時のみ、
    // 原理上は (tap event):(click event):(click event triggered from tap) の計三回発火してしまうが、仕方ないね。

    var input_click = false; // 前フレームから現フレームまでの間にクリックイベントが発生したか否か。
    var input_mdown = false; // 現瞬間においてマウス左ボタンが押下状態にあるか。
    var tapped = 0; // 前フレームから現フレームまでの間にタップイベントが発生したか否か。

    document.addEventListener("click", function (e) {
        if(window.ontouchstart === undefined) {
            input_click = true;
        } else {
            if(tapped > 0) {
                input_click = false;
            } else {
                input_click = true;
                tapped = 0;
            }
        }
    }, false);
    document.addEventListener("mousedown", function (e) {
        if(window.ontouchstart === undefined) {
            input_mdown = true;
//            console.log(input_mdown);
        } else {
            if(tapped > 0) {
                input_mdown = false;
            } else {
                input_mdown = true;
                tapped = 0;
            }
        }
    }, false);
    document.addEventListener("mouseup", function (e) {
        if(window.ontouchstart === undefined) {
            input_mdown = false;
//            console.log(input_mdown);
        } else {
            input_mdown = false;
        }
    }, false);

    // 画面表示用の部品の準備 -------------------------------------------------------------------

    // 以下は、a要素の色を動的に書き換える方法。
    // ただしプライバシー保護上、a:visitedの状態をjavascriptからは取得できない設計になっているのでお蔵入りに。
    // http://stackoverflow.com/questions/5131379/how-to-change-the-color-of-the-links-with-javascript
    var links = document.getElementsByTagName("a");
    for (var i=0; i < links.length; i++) {
        if (links[i].href) {
//            links[i].style.color = "hsla("+semiCol[0]+", "+semiCol[1]+"%, "+semiCol[2]+"%, 1)";
        }
    }

    // デバイスの画面サイズに基づいて部品配置を調整するためのdivコンテナ要素に、名前を付けてjsから触れるようにしておく。
    // こいつらを init() より前に置くと、document.getElementById で要素を取得しようとしてもnullが返るだけ。ふしぎ。
    var div_container1 = document.getElementById('container1');
    var div_container2 = document.getElementById('container2');
    var holder = document.getElementById("holder"); // HTMLでゲーム配置場所の確保だけに使われるcanvas要素。

    // ゲームの色に合わせてhtmlのコンテナの背景色を変更。
    div_container1.style.background = "hsla("+LITE_COL[0]+", "+LITE_COL[1]+"%, "+95+"%, 1)"
    div_container2.style.background = "hsla("+LITE_COL[0]+", "+LITE_COL[1]+"%, "+99+"%, 1)"

    // ゲーム主要部品配置用の1枚目のcanvas要素の定義。ステージごとに描画を切り替える要素、主にゲーム内容自体を置く。
    var canvas = document.getElementById("gamebase");
    var ctx = canvas.getContext("2d");
    var wx = BASE_W; // この初期値は元々htmlに記入されている数値とは関係なく、本ファイル冒頭で定義されている。
    var hx = BASE_H;
    canvas.width = wx;
    canvas.height = hx;
    if (PIX_RATIO > 1.05) {
        canvas.width *= PIX_RATIO;
        canvas.height *= PIX_RATIO;
        canvas.style.width = String(wx + "px");
        canvas.style.height = String(hx + "px");
        ctx.scale(PIX_RATIO, PIX_RATIO); // 高解像度ディスプレイ向けに、コンテキストを拡大してから描画処理を始める
    }
    ctx.baseCol = BASE_COL;
    ctx.semiCol = SEMI_COL;
    ctx.darkCol = DARK_COL;
    ctx.liteCol = LITE_COL;

    // ボタン配置用の2枚目のcanvas要素。どのステージにも共通して描画され、かつフレームごとに更新を要する要素を置く
    gamebutton.oncontextmenu = function () {
        return false; // ゲーム上での右クリック無効化
    }
    var canvas2 = document.getElementById("gamebutton");
    var ctx2 = canvas2.getContext("2d");
    var wx2 = BASE_W;
    var hx2 = BASE_H;
    canvas2.width = wx2;
    canvas2.height = hx2;
    if (PIX_RATIO > 1.05) {
        canvas2.width *= PIX_RATIO;
        canvas2.height *= PIX_RATIO;
        canvas2.style.width = String(wx2 + "px");
        canvas2.style.height = String(hx2 + "px");
        ctx2.scale(PIX_RATIO, PIX_RATIO);
    }
    ctx2.baseCol = BASE_COL;
    ctx2.semiCol = SEMI_COL;
    ctx2.darkCol = DARK_COL;
    ctx2.liteCol = LITE_COL;

    // config用の3枚目のcanvas要素。この要素 "config" はウィンドウの左端にフロート
    config.oncontextmenu = function () {
        return false; // ゲーム上での右クリック無効化
    }
    var canvas3 = document.getElementById("config");
    var ctx3 = canvas3.getContext("2d");
    var wx3 = canvas3.width; // ctx3およびctx4のサイズはhtmlから取得する。
    var hx3 = canvas3.height;
    if (PIX_RATIO > 1.05) {
        canvas3.width *= PIX_RATIO;
        canvas3.height *= PIX_RATIO;
        canvas3.style.width = String(wx3 + "px");
        canvas3.style.height = String(hx3 + "px");
        ctx3.scale(PIX_RATIO, PIX_RATIO);
    }
    ctx3.baseCol = BASE_COL;
    ctx3.semiCol = SEMI_COL;
    ctx3.darkCol = DARK_COL;
    ctx3.liteCol = LITE_COL;

    // デバッグ状態表示用の4枚目のcanvas要素。この要素 "debug" はウィンドウの右端にフロート
    debug.oncontextmenu = function () {
        return false; // ゲーム上での右クリック無効化
    }
    var canvas4 = document.getElementById("debug");
    var ctx4 = canvas4.getContext("2d");
    var wx4 = canvas4.width;
    var hx4 = canvas4.height;
    if (PIX_RATIO > 1.05) {
        canvas4.width *= PIX_RATIO;
        canvas4.height *= PIX_RATIO;
        canvas4.style.width = String(wx4 + "px");
        canvas4.style.height = String(hx4 + "px");
        ctx4.scale(PIX_RATIO, PIX_RATIO);
    }
    ctx4.baseCol = BASE_COL;
    ctx4.semiCol = SEMI_COL;
    ctx4.darkCol = DARK_COL;
    ctx4.liteCol = LITE_COL;


    // sclock用の5枚目のcanvas要素。この要素 "sclock" はウィンドウの左端にある
//    sclock.oncontextmenu = function () {
//        return false; // ゲーム上での右クリック無効化
//    }
    var canvas5 = document.getElementById("sclock");
    var ctx5 = canvas5.getContext("2d");
    var wx5 = canvas5.width;
    var hx5 = canvas5.height;
    if (PIX_RATIO > 1.05) {
        canvas5.width *= PIX_RATIO;
        canvas5.height *= PIX_RATIO;
        canvas5.style.width = String(wx5 + "px");
        canvas5.style.height = String(hx5 + "px");
        ctx5.scale(PIX_RATIO, PIX_RATIO);
    }
    ctx5.baseCol = BASE_COL;
    ctx5.semiCol = SEMI_COL;
    ctx5.darkCol = DARK_COL;
    ctx5.liteCol = LITE_COL;

    canvas2.focus(); // 要素にフォーカスを与える。これでページを開いた直後からスクロールを殺せる

    // ------------------------------------------------------------

    // マウスが動く度に座標を取得する処理。ctxの変数にしておけば、無名関数のスコープ外からも触れる
    // http://hakuhin.jp/js/mouse.html 本ループのタイムラインとは独立に、イベント（マウスの移動）が発生すると動作する。

    // 以下の変数に最初のうち、手動で初期値を設定していなかったためバグが発生していた。
    // イベント依存で更新される変数は一般に、ページ読み込み後、最初のマウス移動イベントが発生するまでundefinedになってしまう。
    ctx.mouse_layer_x = 0;
    ctx.mouse_layer_y = 0;
    ctx2.mouse_layer_x = 0;
    ctx2.mouse_layer_y = 0;
    ctx3.mouse_layer_x = 0;
    ctx3.mouse_layer_y = 0;
    ctx4.mouse_layer_x = 0;
    ctx4.mouse_layer_y = 0;
    ctx5.mouse_layer_x = 0;
    ctx5.mouse_layer_y = 0;

    // 現在のマウス位置に対応するcanvas context上の座標値を算出。
    // ctx.rect.hoge および e.clientX/Y はディスプレイの物理ピクセルではなく論理ピクセルで計算される。
    // 高解像度ディスプレイでは、差分として求めた座標値にdevicePixelRatioを乗じる必要あり。
    document.onmousemove = function(e) {
        ctx.rect = canvas.getBoundingClientRect(); // canvasの絶対座標位置
        ctx.mouse_layer_x = (e.clientX - ctx.rect.left);
        ctx.mouse_layer_y = (e.clientY - ctx.rect.top);
        ctx2.rect = canvas2.getBoundingClientRect();
        ctx2.mouse_layer_x = (e.clientX - ctx2.rect.left);
        ctx2.mouse_layer_y = (e.clientY - ctx2.rect.top);
        ctx3.rect = canvas3.getBoundingClientRect();
        ctx3.mouse_layer_x = (e.clientX - ctx3.rect.left);
        ctx3.mouse_layer_y = (e.clientY - ctx3.rect.top);
        ctx4.rect = canvas4.getBoundingClientRect();
        ctx4.mouse_layer_x = (e.clientX - ctx4.rect.left);
        ctx4.mouse_layer_y = (e.clientY - ctx4.rect.top);
        ctx5.rect = canvas5.getBoundingClientRect();
        ctx5.mouse_layer_x = (e.clientX - ctx5.rect.left);
        ctx5.mouse_layer_y = (e.clientY - ctx5.rect.top);
        return false;
    }

    // ここからスマホ用のTouch objectを作成する処理。イベントリスナーで動くのでループごとに状態更新する必要は無い。
    var tbuffer = new Array(); // 最新のtouch objectのみを収納する箱。
    var texist = 0; // この瞬間に有効なtouch eventが存在するか否か。
    var input_tap = false; // 「タッチの終了時点」で、タッチパネルにおけるタップ相当のイベントを発火させるのだ

    if (window.TouchEvent) {
        if (document.addEventListener) {

            document.addEventListener("touchstart", function (e) {
                var touch_list = e.changedTouches; // TouchList オブジェクトを取得
                var num = touch_list.length;
                for (var i=0; i<num; i++) {
                    tbuffer[i] = touch_list[i]; // Touch オブジェクトを取得
//                    console.log(tbuffer[i].pageX); // 現在有効なtouchだけを表示
                }
                var clx = touch_list[0].clientX;
                var cly = touch_list[0].clientY;
                ctx.rect = canvas.getBoundingClientRect(); // canvasの絶対座標位置
                ctx.mouse_layer_x = (clx - ctx.rect.left); // 明らかにmouseじゃないけど同一視していい
                ctx.mouse_layer_y = (cly - ctx.rect.top);
                ctx2.rect = canvas2.getBoundingClientRect();
                ctx2.mouse_layer_x = (clx - ctx2.rect.left);
                ctx2.mouse_layer_y = (cly - ctx2.rect.top);
                ctx3.rect = canvas3.getBoundingClientRect();
                ctx3.mouse_layer_x = (clx - ctx3.rect.left);
                ctx3.mouse_layer_y = (cly - ctx3.rect.top);
                ctx4.rect = canvas4.getBoundingClientRect();
                ctx4.mouse_layer_x = (clx - ctx4.rect.left);
                ctx4.mouse_layer_y = (cly - ctx4.rect.top);
                ctx5.rect = canvas5.getBoundingClientRect();
                ctx5.mouse_layer_x = (clx - ctx5.rect.left);
                ctx5.mouse_layer_y = (cly - ctx5.rect.top);
                input_tap = false;
                texist = 1; // touch event 存在
                tapped = 1;
                return false;
            }, false); // ここまで touchstart

            document.addEventListener("touchmove", function (e) {
                texist = 1; //
                var touch_list = e.changedTouches; // TouchList オブジェクトを取得
                var num = touch_list.length;
                for (var i=0; i<num; i++) {
                    tbuffer[i] = touch_list[i]; // Touch オブジェクトを取得
                }
                var ad = (screen.width/960);
                var ad = 0.5;
                var clx = touch_list[0].clientX;
                var cly = touch_list[0].clientY;
                ctx.rect = canvas.getBoundingClientRect(); // canvasの絶対座標位置
                ctx.mouse_layer_x = (clx - ctx.rect.left);
                ctx.mouse_layer_y = (cly - ctx.rect.top);
                ctx2.rect = canvas2.getBoundingClientRect();
                ctx2.mouse_layer_x = (clx - ctx2.rect.left);
                ctx2.mouse_layer_y = (cly - ctx2.rect.top);
                ctx3.rect = canvas3.getBoundingClientRect();
                ctx3.mouse_layer_x = (clx - ctx3.rect.left);
                ctx3.mouse_layer_y = (cly - ctx3.rect.top);
                ctx4.rect = canvas4.getBoundingClientRect();
                ctx4.mouse_layer_x = (clx - ctx4.rect.left);
                ctx4.mouse_layer_y = (cly - ctx4.rect.top);
                ctx5.rect = canvas5.getBoundingClientRect();
                ctx5.mouse_layer_x = (clx - ctx5.rect.left);
                ctx5.mouse_layer_y = (cly - ctx5.rect.top);
                input_tap = false;
                if (tapped > 0) {
                    console.log(tbuffer[0]); // 現在有効なtouchを表示
                    console.log("mouse:"+ctx.mouse_layer_x+", "+ctx.mouse_layer_y); // マウスも正しく追随しているか
                }
                return false;
            }, false); // ここまで touchmove

            document.addEventListener("touchend", function (e) {
                texist = 0; //
                tbuffer = [];
                input_tap = true; // 「タッチの終了」というイベントを発生させるのはこの瞬間。
                return false;
            }, false); // ここまで touchend

            document.addEventListener("touchcancel", function (e) {
                texist = 0; //
                tbuffer = [];
                return false;
            }, false); // ここまで touchcancel = マシン内部要因によるタッチ中断

        }
    }

    // デバイス内蔵センサーからのデータ取得 ------------------------------------------------------------

    // ここからスマホ用に回転角と加速度を取得する手続きを試しているが、どうやら本番では使わなさそう？
    var dev_accel = [0, 0, 0];
    var dev_accel_g = [0, 0, 0];
    window.addEventListener("devicemotion", function(e) {
        dev_accel[0] = Math.round(e.acceleration.x*Math.pow(10, 2)) / Math.pow(10, 2);
        dev_accel[1] = Math.round(e.acceleration.y*Math.pow(10, 2)) / Math.pow(10, 2);
        dev_accel[2] = Math.round(e.acceleration.z*Math.pow(10, 2)) / Math.pow(10, 2);
        dev_accel_g[0] = Math.round(e.accelerationIncludingGravity.x*Math.pow(10, 2)) / Math.pow(10, 2);
        dev_accel_g[1] = Math.round(e.accelerationIncludingGravity.y*Math.pow(10, 2)) / Math.pow(10, 2);
        dev_accel_g[2] = Math.round(e.accelerationIncludingGravity.z*Math.pow(10, 2)) / Math.pow(10, 2);
//        console.log("acceleration = "+dev_accel_g); // すぐに出力過多で console が埋まるので使用は慎重に
    });

    var dev_ori = [0, 0, 0];
    window.addEventListener("deviceorientation", function(e) {
        dev_ori[0] = Math.round(e.alpha*Math.pow(10, 2)) / Math.pow(10, 2); // e.alpha (0:360)
        dev_ori[1] = Math.round(e.beta *Math.pow(10, 2)) / Math.pow(10, 2); // e.beta (-180~180)
        dev_ori[2] = Math.round(e.gamma*Math.pow(10, 2)) / Math.pow(10, 2); // e.gamma (-90~90)
//        console.log("orientation = "+dev_ori[2]);
    });
    // 注意 e.webkitCompassHeadingでコンパスの値を取得できたが、最近サポートされなくなっている？

    // 裏話。当初は自機の操作をスマホの本体を傾ける事で実現しようと試みていた。
    // beta==0 で水平。90で直立：カブリ下へ。-90でカブリ前へ。
    // gamma ==0 で水平。-90でカブリ左へ。90でカブリ右へ。
    // ただし、このモデルの実装前にページを横に固定せねば。これが一筋縄ではイカないのだ。
    // 仕様策定中の Screen Orientation API で端末の回転をロックできるが、iOSでは未実装
//    screen.lockOrientation('landscape');
//    screen.addEventListener("orientationchange", function () {
//        console.log("The orientation of the screen is: " + screen.orientation);
//    });

    // ------------------------------------------------------------

    // ゲームパーツ定義。あとで描画先を柔軟に変更できるよう、ここではctx依存のプロパティ定義をなるべく避けること。

    // ゲームの基盤画面作成。
    var disp_main = new Display( depth=5, fromX=(LEAF_FROM_X - LEAF_MARGIN), fromY=(LEAF_FROM_Y - LEAF_MARGIN),
                                 toX=(LEAF_FROM_X + LEAF_W + LEAF_MARGIN), toY=(LEAF_FROM_Y + LEAF_H + LEAF_MARGIN),
                                 angle=0, magnify=1.0, image=texture_seg, repetition='repeat');
    var ilst_keys = new IlstKeys(   depth=8, fromX=LEAF_FROM_X+LEAF_W/2-210,
                                    fromY=LEAF_FROM_Y+LEAF_H/2-50, W=120, H=60);
    var ilst_phone = new IlstPhone( depth=9, fromX=(LEAF_FROM_X+LEAF_W/2+110), fromY=(LEAF_FROM_Y + LEAF_H/2-20),
                                    W=45, H=90, angle=0, magnify=1.0, finger=1 );

    // ゲーム開始・一時停止ボタンの作成。
    var btn_run = new ButtonOver( fromX=PLOT_FROM_X-PLOT_MARGIN, fromY=PLOT_FROM_Y-PLOT_H-PLOT_MARGIN,
                                  w=PLOT_W, h=PLOT_H, radius=2, text_array=["PRESS START","PAUSE"],
                                  power=run, angle=0, magnify=1.0 );

    // 自機をスマホで操作するポインティングデバイスの作成。
    var btn_point = new Dpad(where_x=540, where_y=400, w=240, h=240, radius=120,
                                text_array=["",""], power=run, angle=0, magnify=1.0 );

    // BGMの有効・無効の切り替えボタン
    var btn_bgm = new ButtonBGM( where_x=20, where_y=120, w=60, h=60, radius=80,
                                 text_array=["",""], power=run, angle=0, magnify=1.0 );

    var main00 = new Main00( depth=7, fromX=(LEAF_FROM_X - LEAF_MARGIN), fromY=(LEAF_FROM_Y - LEAF_MARGIN),
                             toX=(LEAF_FROM_X + LEAF_W + LEAF_MARGIN), toY=(LEAF_FROM_Y + LEAF_H + LEAF_MARGIN),
                             font_family='font1', font_size=40, size_unit="px" );

    var main101 = new Main101( depth=7, fromX=(LEAF_FROM_X - LEAF_MARGIN), fromY=(LEAF_FROM_Y - LEAF_MARGIN),
                               toX=(LEAF_FROM_X + LEAF_W + LEAF_MARGIN), toY=(LEAF_FROM_X + LEAF_W + LEAF_MARGIN),
                               font_family='font1', font_size=40, size_unit="px" );

    var main201 = new Main201( depth=7, fromX=(LEAF_FROM_X - LEAF_MARGIN), fromY=(LEAF_FROM_Y - LEAF_MARGIN),
                               toX=(LEAF_FROM_X + LEAF_W + LEAF_MARGIN), toY=(LEAF_FROM_X + LEAF_W + LEAF_MARGIN),
                               font_family='font1', font_size=40, size_unit="px" );

    // 葉は leaf クラスとして『集合』を定義し、その中にleaflet クラスを置く。
    var leaf = new Leaf( depth=7, fromX=LEAF_FROM_X, fromY=LEAF_FROM_Y, toX=(LEAF_FROM_X+LEAF_W),
                         toY=(LEAF_FROM_Y+LEAF_H), nx=16, ny=16, angle=0, magnify=1.0,
                         cx=(LEAF_FROM_X+LEAF_W/2), cy=(LEAF_FROM_Y+LEAF_H/2), image=texture_leaf );
    var leaf_life_sum = leaf.sum(threshold=0); // 葉の残存パッチ。初期値は256
    var leaf_life_sum_initial = leaf_life_sum;
    var array_leaf_sum = [[],[],[]];

    // 自機作成。
    var kaburi = new Kaburi( fromX=LEAF_FROM_X, fromY=LEAF_FROM_Y, toX=LEAF_FROM_X+LEAF_W, toY=LEAF_FROM_Y+LEAF_H,
                             where_x=LEAF_FROM_X+LEAF_W/2, where_y=LEAF_FROM_Y+LEAF_H/2-20, angle=0.0, magnify=2.0);

    // ハダニ個体群作成。なお、ゲーム進行の都合上ここで個体群を定義するが、founder数は stage00 内で調整が入る。
    var enemies = new Population( depth=1, fromX=LEAF_FROM_X, fromY=LEAF_FROM_Y, toX=LEAF_FROM_X+LEAF_W,
                                  toY=LEAF_FROM_Y+LEAF_H, popul_founder=HADANI_FOUNDER, popul_max=HADANI_MAX,
                                  maleratio=HADANI_MALE_RATIO);
    var n_enemies = HADANI_FOUNDER; // 何個体のハダニインスタンスから開始するか。初期数 5
    var enemies_indicator = new InitialEnemies( depth=1, fromX=LEAF_FROM_X+LEAF_W/2-120, fromY=LEAF_FROM_Y+90-10,
                                                toX=LEAF_FROM_X+LEAF_W/2+120, toY=LEAF_FROM_Y+90+10,
                                                founder_max=HADANI_FOUNDER_MAX );
    // 初期ハダニの数を増減させるためのUI
    var HadaniPlus = new ButtonSA(  where_x=LEAF_FROM_X+LEAF_W/2+175, where_y=LEAF_FROM_Y+80, w=80, h=80,
                                    radius=40, text_array=Array("+","+"), power=run, angle=0, magnify=1.0);
    var HadaniMinus = new ButtonSA( where_x=LEAF_FROM_X+LEAF_W/2-195, where_y=LEAF_FROM_Y+80, w=80, h=80,
                                    radius=40, text_array=Array("−","−"), power=run, angle=0, magnify=1.0);
    var hadani_size = HADANI_SIZE; // ゲーム中にハダニの描画倍率を保持させる変数。

    // 現在のハダニ個体数を示す折れ線グラフ作成。 where_x/y はデカルト座標の原点。ここから第一象限にプロット本体が描かれる。
    var disp_plot = new Display(depth=6, fromX=PLOT_FROM_X-PLOT_MARGIN, fromY=PLOT_FROM_Y-PLOT_H-PLOT_MARGIN,
                                toX=PLOT_FROM_X+PLOT_W+PLOT_MARGIN, toY=PLOT_FROM_Y+PLOT_MARGIN+20, angle=0,
                                magnify=1.0, image=texture_seg, repetition='repeat');
    var plot_popul = new Plot( where_x=PLOT_FROM_X, where_y=PLOT_FROM_Y, W=PLOT_W, H=PLOT_H,
                               margin=Array(PLOT_MARGIN+5, PLOT_MARGIN, PLOT_MARGIN, PLOT_MARGIN),
                               xlim=Array(0, MAXTIME), ylim=Array(0, YTICKM),
                               ylim_sub=Array(0, leaf_life_sum_initial),
                               xbreaks1=Array(0, MAXTIME*0.05, MAXTIME*0.1, MAXTIME*0.15, MAXTIME*0.2, MAXTIME*0.25,
                                              MAXTIME*0.3, MAXTIME*0.35, MAXTIME*0.4, MAXTIME*0.45, MAXTIME*0.5,
                                              MAXTIME*0.55, MAXTIME*0.6, MAXTIME*0.65, MAXTIME*0.7, MAXTIME*0.75,
                                              MAXTIME*0.8, MAXTIME*0.85, MAXTIME*0.9, MAXTIME*0.95, MAXTIME ),
                               xbreaks2=Array(0, MAXTIME*0.25, MAXTIME*0.5, MAXTIME*0.75, MAXTIME),
                               ybreaks1=Array(YTICKM*0.05, YTICKM*0.1, YTICKM*0.15,
                                              YTICKM*0.2,  YTICKM*0.3, YTICKM*0.35,
                                              YTICKM*0.4, YTICKM*0.45,
                                              YTICKM*0.55, YTICKM*0.6, YTICKM*0.65, YTICKM*0.7,
                                              YTICKM*0.8, YTICKM*0.85, YTICKM*0.9, YTICKM*0.95 ),
                               ybreaks2=Array(0, YTICKM*0.25, YTICKM*0.5, YTICKM*0.75, YTICKM),
                               logx=0, logy=0, xlab="TIME", ylab="Prey", ylab_sub="Leaf",
                               type="area", type_sub="line", col_ary=HADANI_COL_ARRAY, col_sub_ary=HADANI_COL_ARRAY2 );

    // ハダニの個体数を表示するための積み上げデータを格納する配列。未登録と死亡を除外した長さ5
    var hadani_tumiage_array = [[], [], [], [], []]; // 最初に名無しの空配列を作って5つまとめ、後から要素をプッシュする
    var hadani_dyn_temp = [0,0,0,0,0]; // 0:卵, 1:幼虫, 2:静止期, 3:雌成虫, 4:オス成虫
    // ハダニ個体数の積み上げデータの初期化。ここでデータを入れておけば、ゲームのstage01に入るまでは、更新しなくてもいい。
    if (plot_popul.type=="line") {
        plot_popul.setStatus(currentFrame=frame_raw, data=enemies.dyn_array, data_sub=array_leaf_sum);
    } else if (plot_popul.type=="area") {
        plot_popul.setStatus(currentFrame=frame_raw, data=hadani_tumiage_array, data_sub=array_leaf_sum);
    }

    // 開始からのフレーム数を示す7セグディスプレイ作成。
    // ひょっとして経過時間＝秒数のほうがいいのかもしれないが、今のところは時間の単位＝フレームなのだよねえ
    var ssd_cf = new SSD( depth_from=100, LEN_MAX=4, digit=4, where_x=PLOT_FROM_X+PLOT_H*0.1,
                          where_y=PLOT_FROM_Y-PLOT_H/2, h=36, col_R=160, col_G=165, col_B=165, data=0 );

    // ゲームのコンフィグを表示させたり隠したりするためのボタン。この辺は次のバージョンでconfigの関数として独立させる
    var config_base = new Config( depth_from=100002, from="left", where_x=0, where_y=0, W=wx3, H=w_hidden+3,
                                  Whide=w_hidden, Hhide=hx3, radius=15, isopen=0, font_family='Arial',
                                  font_size=10, size_unit="px", text_array=Array("Show","Hide") );
    var icon_config = new IconConfig( depth_from=100003, where_x=wx3-32-9, where_y=10, W=32, H=32 );

    // デバッグ画面表示切り替えのオブジェクト作成。Debugクラスは後で作るか、単純に引数だけを変えてそれらしく見せるか。
    var debug_base = new Config( depth_from=100102, from="right", where_x=0, where_y=0, W=wx4, H=w_hidden+3,
                                Whide=w_hidden, Hhide=hx4, radius=15, isopen=0, font_family='Arial',
                                font_size=10, size_unit="px", text_array=Array("Show","Hide") );
    var icon_debug = new IconConfig( depth_from=100003, where_x=9, where_y=10, W=32, H=32 );

    // 栄養間相互作用のリンク状態を表すためのアイコン
    var link_base = new LinkBase( depth_from=100010, angle=Math.PI*0, magnify=1,
                                  where_x=LEAF_FROM_X+LEAF_W/2, where_y=440, W=420, H=70);
    var icon_show_leaf = new IconLeaf(  depth_from=100031, angle=Math.PI*0, magnify=1,
                                        where_x=LEAF_FROM_X+LEAF_W/2-160, where_y=440, W=40, H=40);
    var icon_chain_p2h = new IconChain( depth_from=100011, angle=Math.PI*0.0, magnify=1,
                                        where_x=LEAF_FROM_X+LEAF_W/2-75, where_y=440, W=40, H=50, connected=1 );
    var config_show_hadani = new InitialHadani( where_x=LEAF_FROM_X+LEAF_W/2, where_y=440,
                                                angle=-Math.PI*0.5, magnify=1.50);
    var icon_chain_h2k = new IconChain( depth_from=100021, angle=Math.PI*0.0, magnify=1,
                                        where_x=LEAF_FROM_X+LEAF_W/2+75, where_y=440, W=40, H=50, connected=1 );
    var config_show_kaburi = new Kaburi(fromX=0, fromY=0, toX=wx3, toY=hx3, where_x=LEAF_FROM_X+LEAF_W/2+155,
                                        where_y=440, angle=Math.PI*0.5, magnify=1.20);

    // 現在の実現FPSを示すスピードメーター。
    var speedometer = new AnalogueMeter( depth_from=1, ndata=10, d_default=1000/FPS, lim=Array(0, 100),
                                        where_x=75, where_y=130, W=100, H=100,
                                        font_family='sans-serif', font_size=9, size_unit="px");

    // スクロールロックの状態を表示するアイコン
    var icon_scroll = new IconScLock( depth_from= 10004, where_x=10, where_y=10, W=60, H=60 );

    // ------------------------------------------------------------

    // 2016/05/22 arguments.calleeを使う処理は deprecated であり、ループのパフォーマンスとしても最悪らしい。
    // 本当に速い setTimeout の作り方。postMessageメソッドを使う。
    // http://dbaron.org/log/20100309-faster-timeouts
    // 上記サイトの例を改造し、一定のインターバルで実行できるようにしたもの。
    (function () {
        var timeouts = [];
        var messageName = "zero-timeout-message";
        function setZeroTimeout(fn) {
            timeouts.push(fn);
            window.postMessage(messageName, "*");
            // otherWindow.postMessage(message, targetOrigin); は、 message という内容のメッセージを、
            // 生成元ウィンドウである targetOrigin （*の場合は自動生成されたリテラル）を指定して、
            // 別のウィンドウオブジェクト otherWindow に届ける。
        }
        function handleMessage(event) {
            if (event.source == window && event.data == messageName) {
                event.stopPropagation();
                if (timeouts.length > 0) {
                    var fn = timeouts.shift();
                    fn();
                }
            }
        }
        // 現在のウィンドウオブジェクトに、メッセージ受け取りのイベントハンドラを追加。
        window.addEventListener("message", handleMessage, true);
        gameLoop(); // この関数（下で定義）がゲームの処理内容の実体。
        window.setZeroTimeout = setZeroTimeout;
    }) ();


    // どのステージでも毎フレーム実行されるゲームループ関数。ステージ依存の処理はさらに内部のサブルーチンに。
    function gameLoop() {

        //console.timeEnd('timer_WaitBetweenFrames');
        // 最初のうちはマウス位置や現在時刻の取得であり、これはゲームのどのステージ画面にも共通する要素。

        // ここからフレーム進行に関する計算が続く
        var gameLoopTimer = setTimeout(gameLoop, FPS-1); // ループ頭でタイムアウトのオブジェクトを作成するのがコツ
        oldd = d; // 初期化はループに入る前に済ませてある
        oldd2 = d2;
        d = new Date(); // 現在時刻をミリ秒単位で変数に代入
        // 前フレームからの実経過時間の逆数＝実効FPSに相当。
        speedometer.setStatus(data=Math.round(10000/(d-oldd)) / 10, pss=oldd2-oldd); // スピードメーターの値セット
        ssd_cf.setStatus(num=frame_raw, where_x=ssd_cf._x, where_y=ssd_cf._y); // 経過フレーム数のディスプレイを更新

        // ボタン押下状態の処理に入る前に、タッチの押下フラグを処理。現フレームでのマウスクリックに読み替え、フラグおろす。
        if (input_tap == true) {
            input_click = true;
        }
        if (input_click == true) {
            input_tap = false;
        }

        // 画面の縦位置と横位置に応じて、部品の描画位置を調整する。
        if (div_container2.clientWidth >= 790 || Math.abs(window.orientation)%180 >= 45) {
            // windowの描画領域が横長、つまり通常のPCのディスプレイ
            holder.style.width = "780px";
            holder.style.height = "600px"; // 後続のDOM要素との間隔を決めるのはこいつ。
            canvas.style.width = "780px";
            canvas.style.height = "600px";
            canvas2.style.width = "780px";
            canvas2.style.height = "600px";
            canvas.width = "780";
            canvas.height = "600";
            canvas2.width = "780";
            canvas2.height = "600";
            disp_plot._x = PLOT_FROM_X-PLOT_MARGIN;
            disp_plot._y = PLOT_FROM_Y-PLOT_H-PLOT_MARGIN;
            plot_popul._x = PLOT_FROM_X;
            plot_popul._y = PLOT_FROM_Y;
            ssd_cf._x = PLOT_FROM_X+PLOT_H*0.1;
            ssd_cf._y = PLOT_FROM_Y-PLOT_H/2;
            btn_run._x = PLOT_FROM_X;
            btn_run._y = PLOT_FROM_Y-PLOT_H;
            btn_point._x = PLOT_FROM_X-PLOT_MARGIN;
            btn_point._y = PLOT_FROM_Y+PLOT_MARGIN+40;
        } else {
            // windowの描画領域が縦、つまりスマホのportraitなど
            holder.style.width = "560px";
            holder.style.height = "800px"; // 後続のDOM要素との間隔を決めるのはこいつ。
            canvas.style.width = "560px";
            canvas.style.height = "800px";
            canvas2.style.width = "560px";
            canvas2.style.height = "800px";
            canvas.width = "560";
            canvas.height = "800";
            canvas2.width = "560";
            canvas2.height = "800";
            disp_plot._x = LEAF_FROM_X-LEAF_MARGIN;
            disp_plot._y = LEAF_FROM_Y+LEAF_H+LEAF_MARGIN+10;
            plot_popul._x = LEAF_FROM_X-LEAF_MARGIN+PLOT_MARGIN;
            plot_popul._y = LEAF_FROM_Y+LEAF_H+LEAF_MARGIN+10+PLOT_MARGIN+PLOT_H;
            ssd_cf._x = plot_popul._x+PLOT_H*0.1;
            ssd_cf._y = plot_popul._y-PLOT_H/2;
            btn_run._x = LEAF_FROM_X-LEAF_MARGIN+PLOT_MARGIN;
            btn_run._y = LEAF_FROM_Y+LEAF_H+LEAF_MARGIN+10+PLOT_MARGIN;
            btn_point._x = LEAF_FROM_X-LEAF_MARGIN+2*PLOT_MARGIN+PLOT_W+30;
            btn_point._y = LEAF_FROM_Y+LEAF_H+LEAF_MARGIN+PLOT_MARGIN+10;
        }

        // ゲームのコンフィグに関する処理。現フレームのshow_configが有効な場合のみ設定可に。
        if (show_config == true) {
            if ((input_click == true || input_tap == true) && (icon_chain_p2h.onMouse == true)) {
                chain_plant_hadani = 1 - chain_plant_hadani;
            }
            icon_chain_p2h.setStatus(connected=chain_plant_hadani);
            if ((input_click == true || input_tap == true) && (icon_chain_h2k.onMouse == true)) {
                chain_hadani_kaburi = 1 - chain_hadani_kaburi;
            }
            icon_chain_h2k.setStatus(connected=chain_hadani_kaburi);
            config_show_hadani.setStatus(magnify=1.0, x=1); // リンクチェーンのために図示するハダニ
            kaburi_power_supply = 1-chain_hadani_kaburi;
            // 現在はひとまず、power supplyと栄養間リンクを完全に連動。
            // 本来は「電源接続しつつ捕食も可能」というモードが可能なのだが、そのためにはカブリにボタンを置く必要。
            config_show_kaburi.powersupply = kaburi_power_supply;
        }

        // その後、最新ループにおける表示非表示ボタンの押下状態を取得し、config自体の描画を決める
        if ((input_click == true || input_tap == true) && (icon_config.onMouse == true || config_base.onMouse == true)) {
            show_config = 1 - show_config;
        }
        config_base.setStatus(power=show_config);        // config画面をアクティブにするかどうか
        icon_config.setStatus(power=show_config);        // configボタンをアクティブにするかどうか

        // 最新ループにおける、デバッグの表示非表示ボタンの押下状態を取得する。
        if ((input_click == true || input_tap == true) && (icon_debug.onMouse == true || debug_base.onMouse == true)) {
            show_debug = 1 - show_debug;
        }
        debug_base.setStatus(power=show_debug);        // debug画面をアクティブにするかどうか
        icon_debug.setStatus(power=show_debug);        // debugボタンをアクティブにするかどうか

        // 現在のアクティブエレメントの指定
        if ((input_click == true || input_tap == true) && icon_scroll.onMouse == true ) {
            scroll_lock = 1 - scroll_lock;
            if (scroll_lock > 0) {
                canvas2.focus();
            }
        }
        if (document.activeElement.id=='gamebase'||document.activeElement.id=='gamebutton'||document.activeElement.id=='holder') {
            scroll_lock = 1;
            icon_scroll.setStatus(lock=1);
        } else {
            icon_scroll.setStatus(lock=0);
        }
//        console.log(document.activeElement.id +" "+scroll_lock+" "+icon_scroll.lock);

        // ゲームのリプレイの決定をここで行う。
        // マウスボタンの押下状態を取得し、カーソルがスタートボタンの上、かつマウスボタンが押されていたらフラグを立てる。
        if (btn_run.waitReset == true && btn_run.onMouse == true && input_click == true) {
            location.reload(false); // false のとき、ブラウザのキャッシュからページを再読み込みする。
        }


        // ----------------------------------- ここから、1枚目のcanvasの描画処理(正確に言うとゲームの内容処理も)

        // 毎フレームの描画前に、描画領域をクリア
        ctx.clearRect(0, 0, wx, hx); // screenクリア
        ctx2.clearRect(0, 0, wx2, hx2); // screenクリア
//        basement.drawme(ctx); // 現行バージョンではベースを塗らないことにした。
        disp_main.drawme(ctx); // 動作は問題ないが、何かパラメータの指定漏れがあるみたい

        // stage==0 のときは run==0で初期化しており、stage=1 を代入するときに初めて run=1 を代入する
        // 実際にstage進行を管理しているのは各ステージのサブルーチンで、たとえばstage00()のループ内でstage=1へ条件分岐する
        if (stage == 0) {
            stage00(); // ゲーム開始前のタイトル画面
        } else if (stage == 1) {
            stage01(); // ゲーム本編
        } else if(stage == 101) {
            stage101(); // バッドエンドに伴う表示画面
        } else if(stage == 201) {
            stage201(); // クリアに伴う成績表示画面
        } else {
            ;
        }

        // ----------------------------------- ここから、2枚目のcanvasの描画処理（1枚目はstage関数の内部で描画）

        btn_run.setStatus(power=run); // 開始ボタンはステージ関数内で調整
        btn_point.setStatus(ctx2, texist, input_mdown);
        disp_plot.drawme(ctx2);
        btn_point.drawme(ctx2);
        btn_run.drawme(ctx2);
        plot_popul.drawme(ctx2);
        ssd_cf.drawme(ctx2);

        // ----------------------------------- ここから、3枚目のcanvasの描画処理

        // コンフィグ画面などはゲームの進行（ステージ）とは独立に表示状態を切り替えるので、ステージ関数と分離。
        // 場所はstage00()などの関数呼び出しより後。でないと描画時の上下が狂う
        // 元々div要素が壁に貼り付いているので、html要素のwidthをjsから変えることで飛び出しを表現できる。
        // getElementIDで取得したcanvas要素の属性を直接いじって、幅を変更できるゾ。
        // なおcanvasのサイズをはみ出した部分は描画されないだけなので、深く考えなくてもいい。
        // タブレットでスワイプして要素を動かせるとかっこいいが、まあ暇ができたら考える。

        // 未開発の特殊なゲームモード
        // 植物の再生産を実装→理屈上、ゲームが永久に続くおそれ。まあテトリス方式で長く続けるゲームでもいいが。
        // この場合は先に上限を決めて格納ではなく、データオブジェクトをリサイクルする必要がある。
        // 「下克上モード」カブリダニを操作して、増えるハダニから逃げ続けるゲーム。当たったら負け。

        ctx3.clearRect(0, 0, wx3, hx3); // screenクリア
        var radiusL = 0;
        var radiusR = 15;
        var wi = wx3;
        var hi = hx3;
        ctx3.fillStyle = "hsla("+ctx3.baseCol[0]+", "+ctx3.baseCol[1]+"%, "+ctx3.baseCol[2]+"%, 0.85)";
        ctx3.strokeStyle = "hsla("+ctx3.darkCol[0]+", "+ctx3.darkCol[1]+"%, "+ctx3.darkCol[2]+"%, 1)";
        ctx3.lineWidth = 2.5;
        ctx3.save();
        ctx3.translate(0- (1-show_config)*(wx3-w_hidden), 0);
        ctx3.beginPath();
        ctx3.moveTo(0, radiusL);
        ctx3.lineTo(0, hi-radiusL);
        ctx3.quadraticCurveTo(0, hi, radiusL, hi); // ひだりした
        ctx3.lineTo(wi-radiusR, hi);
        ctx3.quadraticCurveTo(wi, hi, wi, hi-radiusR); // みぎした
        ctx3.lineTo(wi, radiusR);
        ctx3.quadraticCurveTo(wi, 0, wi-radiusR, 0); // みぎうえ
        ctx3.lineTo(radiusL, 0);
        ctx3.quadraticCurveTo(0, 0, 0, radiusL); // ひだりうえ
        ctx3.closePath();
        ctx3.fill();
        ctx3.clip(); // 描画範囲を限定

        config_base.drawme(ctx3); // configのクリック反応領域を描画
        icon_config.drawme(ctx3);

        // BGM有無のボタン描画。実際には、ctx2とctx3どちらがいいのかな
        if (silent <= 0) {
            btn_bgm.setStatus(power=enable_bgm);
            btn_bgm.drawme(ctx3);
        }
        // 未対応：クリア画面のみ別の音楽を鳴らす
        // フェードアウトの仕組みも実装したが、問題はiOSでmedia.volumeが効くかどうか。

        ctx3.restore(); // 描画位置を手動でオフセットしたので、戻す必要がある。

        // ----------------------------------- ここまで、3枚目のcanvasの描画処理

        // ----------------------------------- ここから、4枚目のcanvasの描画処理

        ctx4.clearRect(0, 0, wx4, hx4); // screenクリア
        var radiusL = 15;
        var radiusR = 0;
        var wi = wx4;
        var hi = hx4;
        ctx4.fillStyle = "hsla("+ctx4.baseCol[0]+", "+ctx4.baseCol[1]+"%, "+ctx4.baseCol[2]+"%, 0.85)";
        ctx4.strokeStyle = "hsla("+ctx4.darkCol[0]+", "+ctx4.darkCol[1]+"%, "+ctx4.liteCol[2]+"%, 1)";
        ctx4.lineWidth = 6.0;
        ctx4.save();
        ctx4.translate((1-show_debug)*(wx4-w_hidden), 0);
        ctx4.beginPath();
        ctx4.moveTo(0, radiusL);
        ctx4.lineTo(0, hi-radiusL);
        ctx4.quadraticCurveTo(0, hi, radiusL, hi); // ひだりした
        ctx4.lineTo(wi-radiusR, hi);
        ctx4.quadraticCurveTo(wi, hi, wi, hi-radiusR); // みぎした
        ctx4.lineTo(wi, radiusR);
        ctx4.quadraticCurveTo(wi, 0, wi-radiusR, 0); // みぎうえ
        ctx4.lineTo(radiusL, 0);
        ctx4.quadraticCurveTo(0, 0, 0, radiusL); // ひだりうえ
        ctx4.closePath();
        ctx4.fill();
        ctx4.clip(); // 描画範囲を限定

        speedometer.drawme(ctx4);        // スピードメーター描画
        debug_base.drawme(ctx4); // debugのクリック反応領域を描画
        icon_debug.drawme(ctx4);

        ctx4.restore();

        // ----------------------------------- ここまで、4枚目のcanvasの描画処理

        // ----------------------------------- ここから、5枚目のcanvasの描画処理
        ctx5.clearRect(0, 0, wx5, hx5); // screenクリア
        icon_scroll.drawme(ctx5);
        // ----------------------------------- ここまで、5枚目のcanvasの描画処理

        d2 = new Date(); // 処理完了時の経過時間を計算
        pss = d2 - d; // フレーム突入時からの経過時間
        if (game==false) {
            // ループ作成箇所は末尾ではなく、毎回常に冒頭でセットする形式。ゲーム終了時にタイマーを削除することで、その回限りで離脱。
            clearTimeout(gameLoopTimer);
        }

        console.time('timer_WaitBetweenFrames');
    } // ここまで gameloop();

    // ここから各ステージの状態更新・描画関数の定義 -------------------------------------------------------------------
    // これらの関数定義は、initの関数定義の内部にあることに注意。外側に置くと別のスコープなので変数が自動的に渡らない。

    // stage00() 関数の定義 -------------------------------------------------------------------
    function stage00() {

        if (silent <= 0) {
            if (btn_bgm.onMouse == true && input_click == true) {
                enable_bgm = 1-enable_bgm; // BGM再生有無を設定するためのボタン押下状態を取得し、変数に値をセット
            }
        }

        // ゲームの進行中／一時停止の決定をここで行う。ゲーム終了はrunではなくgameフラグで行う。
        // マウスボタンの押下状態を取得し、カーソルがスタートボタンの上、かつマウスボタンが押されていたらフラグを立てる。
        if (btn_run.onMouse == true && input_click == true) {
            run = 1;
            stage = 1;
            enemies.init(popul_founder=n_enemies, popul_max=HADANI_MAX, maleratio=0);
            if (silent <= 0 && enable_bgm > 0) {
                bgm.play(); // ゲーム自体のボタンが一度も押されなければ、結局BGMをプレイする必要はない。
            }
        }
        // ハダニ初期個体数を増減するためのマウスボタン押下状態を取得し、インジケーターに値をセット
        if (HadaniPlus.onMouse == true && (input_click == true || input_tap == true)) {
            n_enemies = n_enemies+1;
        }
        if (HadaniMinus.onMouse == true && (input_click == true || input_tap == true)) {
            n_enemies = n_enemies-1;
        }
        if (n_enemies >= HADANI_FOUNDER_MAX) {
            n_enemies = HADANI_FOUNDER_MAX;
        } else if (n_enemies < 0) {
            n_enemies = 0;
        }
        enemies_indicator.setStatus(magnify=0.75, x=n_enemies);
        kaburi.setRotate(input_keys, btn_point, enemies, 1.5, kaburi_power_supply); // 拡大倍率を要検討

        // ----------------------------------- ここから、1枚目のcanvasの描画処理

        main00.drawme(ctx);
        ilst_keys.setStatus(input_keys);
        ilst_keys.drawme(ctx);
        ilst_phone.drawme(ctx);
        kaburi.drawme(ctx); // カブリダニ

        HadaniPlus.setStatus(power=run);
        HadaniPlus.drawme(ctx); // ハダニ増減のボタン描画。
        HadaniMinus.setStatus(power=run);
        HadaniMinus.drawme(ctx); // 初期ハダニ個体数のインジケーター描画
        enemies_indicator.drawme(ctx);

        link_base.drawme(ctx, transparency=0.4);
        icon_show_leaf.drawme(ctx);
        icon_chain_p2h.drawme(ctx); // リンクチェーンアイコン（葉っぱとハダニ）
        config_show_hadani.drawme(ctx); // リンクチェーンのために図示するハダニを描画
        icon_chain_h2k.drawme(ctx); // リンクチェーンアイコン（ハダニとカブリダニ）
        config_show_kaburi.drawClipping(ctx, 0, 0, wx, hx); // リンクチェーンのために図示するカブリを描画

        input_click = false; // フレーム内の全状態判定がすんだら、マウスのクリック状態を戻す。
        input_tap = false; // フレーム内の全状態判定がすんだら、タップを消す。
    }


    // stage01() 関数の定義 -------------------------------------------------------------------
    function stage01() {

        // マウスボタンの押下状態を取得する。
        if (btn_run.onMouse == true && (input_click == true || input_tap == true)) {
            run = 1 - run;
        }
        if (silent <= 0) {
            // BGM再生有無を設定するためのマウスボタン押下状態を取得し、変数に値をセット
            if (btn_bgm.onMouse == true && input_click == true) {
                enable_bgm = 1-enable_bgm;
            }
            if (enable_bgm > 0 && run > 0) {
//                console.log("bgm/game_running : "+enable_bgm + "/" + run);
                bgm.play(); //
            } else {
                bgm.pause(); // pause() → play() は現在の再生ヘッドから再生再開
                // bgmがプレイ状態のところに追加で play() 信号を送っても、冒頭に戻ったりパニック状態にはならない。
            }
        }

        // ゲームの進行中／一時停止の決定を run フラグで行う。gameフラグだとゲームループそのものから抜ける。
        // 制限時間を超えるとゲームを止め、stage01からも抜ける。
        // なおここで使う leaf_life_sum, kaburi.life は厳密には直前のフレームでの値である。
        if (frame_raw > MAXTIME || leaf_life_sum <= 0 || kaburi.life <= 0) {
            run = 0;
            kaburi.reset(where=true, angle=true, magnify=false, experience=false, speed=false, life=false);
            kaburi._x = LEAF_FROM_X+LEAF_W/2+20;
            kaburi._y = LEAF_FROM_Y+LEAF_H/2+25;
            btn_run.waitReset = true;
            stage = 101; // 101はゲームオーバー
        } else if ((hadani_dyn_temp[4] <= 0 && enemies.eaten_total > 0) || n_enemies <= 0) {
            run = 0;
            kaburi.reset(where=true, angle=true, magnify=false, experience=false, speed=false, life=false);
            kaburi._x = LEAF_FROM_X+LEAF_W/2+20;
            kaburi._y = LEAF_FROM_Y+LEAF_H/2+22;
            btn_run.waitReset = true;
            stage = 201; // 201はゲームクリア
        }

        if (ctx.mouse_layer_x >= LEAF_FROM_X && ctx.mouse_layer_y >= LEAF_FROM_Y &&
            ctx.mouse_layer_x <= LEAF_FROM_X+LEAF_W && ctx.mouse_layer_y <= LEAF_FROM_Y+LEAF_H ) {
            show_link = 0.5;
        } else {
            if (show_link > 0) {
                show_link = show_link - 0.05; // マウスが葉っぱから外れると、リンク設定が徐々にフェードアウト
            }
        }

        input_click = false; // ゲームの進行判定がすんだら、マウスのクリック状態を戻す。
        input_tap = false; // フレーム内の全状態判定がすんだら、タップを消す。

        // ここから、run > 0 かつ時間制限内のときだけ走るゲーム本番処理 -----------------------------------
        if(run > 0 && frame_raw <= MAXTIME) {

            hadani_size = 0.5+Math.random()*0.08; // ハダニ描画サイズ変更。

            // キャラクターのステータス更新
            enemies.setStatus(ctx, leaf, kaburi, hadani_size, chain_plant_hadani, chain_hadani_kaburi);
            kaburi.setStatus(input_keys, btn_point, enemies, 1.5, kaburi_power_supply); // 拡大倍率を要検討

            leaf_life_sum = leaf.sum(threshold=0); // 葉の残存パッチ数を計算。ハダニより後、グラフより前
            array_leaf_sum[1].push(leaf_life_sum);

            // ハダニ個体数の積み上げデータのステータス更新
            if (plot_popul.type=="line") {
                plot_popul.setStatus(currentFrame=frame_raw, data=enemies.dyn_array, data_sub=array_leaf_sum);
            } else if (plot_popul.type=="area") {
                for (var i = 0; i < 5; i=(i+1)|0) {
                    hadani_dyn_temp[i] = enemies.dyn_array[i+1][frame_raw]; // dyn_arrayには0:未登録があるので1ずれる
                    for (var j = 0; j <= i; j=(j+1)|0) {
                        hadani_dyn_temp[i] = hadani_dyn_temp[i] + enemies.dyn_array[j+1][frame_raw];
                    }
                }
                for (var i = 0; i < 5; i=(i+1)|0) {
                    hadani_tumiage_array[i].push(hadani_dyn_temp[i]);
                }
                plot_popul.setStatus(currentFrame=frame_raw, data=hadani_tumiage_array, data_sub=array_leaf_sum);
            }

//            if (frame_raw%200 == 0 ) {
//                leaf.reset(); // ためしに、葉っぱを未加害に戻すチートメソッドを書いてみた。
//                kaburi.reset(where=true, angle=false, magnify=false, experience=true, speed=true, life=true);
//            }

            frame_raw = (frame_raw+1)|0; // 経過フレームをインクリメント
        } // ----------------------------------- ここまで、run > 0 のときだけ走る

        leaf.drawme(ctx);
        enemies.drawClipping( ctx, LEAF_FROM_X, LEAF_FROM_Y, (LEAF_FROM_X+LEAF_W), (LEAF_FROM_Y+LEAF_H));
        kaburi.drawClipping(ctx, LEAF_FROM_X, LEAF_FROM_Y, (LEAF_FROM_X+LEAF_W), (LEAF_FROM_Y+LEAF_H));

        // リンクチェーンアイコンを描画
        if (show_link > 0) {
            link_base.drawme(ctx, transparency=show_link);
            icon_show_leaf.drawme(ctx);
            icon_chain_p2h.drawme(ctx);
            config_show_hadani.drawme(ctx); // リンクチェーンのために図示するハダニを描画
            icon_chain_h2k.drawme(ctx);
            config_show_kaburi.drawClipping(ctx, 0, 0, wx, hx); // リンクチェーンのために図示するカブリを描画
        }
    }

    // ゲームオーバー：stage101() 関数の定義 -------------------------------------------------------------------
    function stage101() {
        run = 0;
        input_click = false; // ゲームの進行判定がすんだら、マウスのクリック状態を戻す。
        input_tap = false; // フレーム内の全状態判定がすんだら、タップを消す。
       if (silent <= 0) {
            bgm.volume = bgm.volume * 0.75;
            if (bgm.volume <= 0.015) {
                bgm.pause();
            }
        }

        // ゲームのリプレイの決定をここで行う。
        // マウスボタンの押下状態を取得し、カーソルがスタートボタンの上、かつマウスボタンが押されていたらフラグを立てる。
        if (btn_run.onMouse == true && input_click == true) {
            run = 0;
            stage = 0;
            enemies.init(popul_founder=n_enemies, popul_max=HADANI_MAX, maleratio=0);
        }

        main101.setStatus(frame_raw, leaf, leaf_life_sum, enemies, kaburi);
        main101.drawme(ctx); // ゲームの敗戦処理内容描画。
    }

    // クリア後：stage201() 関数の定義 -------------------------------------------------------------------
    function stage201() {
        run = 0;
        input_click = false; // ゲームの進行判定がすんだら、マウスのクリック状態を戻す。
        input_tap = false; // フレーム内の全状態判定がすんだら、タップを消す。
        if (silent <= 0) {
            bgm.volume = bgm.volume * 0.75;
            if (bgm.volume <= 0.015) {
                bgm.pause();
            }
        }
        main201.setStatus(frame_raw, leaf, leaf_life_sum, enemies, kaburi);
        main201.drawme(ctx); // ゲームの敗戦処理内容描画。
    } // ここまで、各ステージの状態更新・描画関数の定義 -------------------------------------------------------------------

} // ここまで、init() 関数の定義 -------------------------------------------------------------------
